/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.util.Zip4jUtil;

public class SplitOutputStream
extends OutputStream {
    private File outFile;
    private RandomAccessFile raf;
    private long bytesWrittenForThisPart;
    private static final int[] lllllll;
    private int currSplitFileCounter;
    private long splitLength;
    private File zipFile;

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        if (this.splitLength != -1L) {
            if (this.splitLength < 65536L) {
                throw new IOException("split length less than minimum allowed split length of 65536 Bytes");
            }
            if (this.bytesWrittenForThisPart >= this.splitLength) {
                this.startNextSplitFile();
                this.raf.write(b, off, len);
                this.bytesWrittenForThisPart = len;
            } else if (this.bytesWrittenForThisPart + (long)len > this.splitLength) {
                this.raf.write(b, off, (int)(this.splitLength - this.bytesWrittenForThisPart));
                this.startNextSplitFile();
                this.raf.write(b, off + (int)(this.splitLength - this.bytesWrittenForThisPart), (int)((long)len - (this.splitLength - this.bytesWrittenForThisPart)));
                this.bytesWrittenForThisPart = (long)len - (this.splitLength - this.bytesWrittenForThisPart);
            } else {
                this.raf.write(b, off, len);
                this.bytesWrittenForThisPart += (long)len;
            }
        } else {
            this.raf.write(b, off, len);
            this.bytesWrittenForThisPart += (long)len;
        }
    }

    @Override
    public void flush() throws IOException {
    }

    public SplitOutputStream(String name, long splitLength) throws FileNotFoundException, ZipException {
        this(!Zip4jUtil.isStringNotNullAndNotEmpty(name) ? new File(name) : null, splitLength);
    }

    public long getSplitLength() {
        return this.splitLength;
    }

    static {
        SplitOutputStream.lIIllII();
    }

    private void startNextSplitFile() throws IOException {
        try {
            String zipFileWithoutExt = Zip4jUtil.getZipFileNameWithoutExt(this.outFile.getName());
            File currSplitFile = null;
            String zipFileName = this.zipFile.getAbsolutePath();
            currSplitFile = this.currSplitFileCounter < lllllll[2] ? new File(this.outFile.getParent() + System.getProperty("file.separator") + zipFileWithoutExt + ".z0" + (this.currSplitFileCounter + lllllll[1])) : new File(this.outFile.getParent() + System.getProperty("file.separator") + zipFileWithoutExt + ".z" + (this.currSplitFileCounter + lllllll[1]));
            this.raf.close();
            if (currSplitFile.exists()) {
                throw new IOException("split file: " + currSplitFile.getName() + " already exists in the current directory, cannot rename this file");
            }
            if (!this.zipFile.renameTo(currSplitFile)) {
                throw new IOException("cannot rename newly created split file");
            }
            this.zipFile = new File(zipFileName);
            this.raf = new RandomAccessFile(this.zipFile, "rw");
            this.currSplitFileCounter += lllllll[1];
        }
        catch (ZipException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int getCurrSplitFileCounter() {
        return this.currSplitFileCounter;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buff = new byte[lllllll[1]];
        buff[SplitOutputStream.lllllll[0]] = (byte)b;
        this.write(buff, lllllll[0], lllllll[1]);
    }

    public SplitOutputStream(File file, long splitLength) throws ZipException, FileNotFoundException {
        if (splitLength >= 0L && splitLength < 65536L) {
            throw new ZipException("split length less than minimum allowed split length of 65536 Bytes");
        }
        this.raf = new RandomAccessFile(file, "rw");
        this.splitLength = splitLength;
        this.outFile = file;
        this.zipFile = file;
        this.currSplitFileCounter = lllllll[0];
        this.bytesWrittenForThisPart = 0L;
    }

    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    public SplitOutputStream(String name) throws ZipException, FileNotFoundException {
        this(Zip4jUtil.isStringNotNullAndNotEmpty(name) ? new File(name) : null);
    }

    public boolean isSplitZipFile() {
        return this.splitLength != -1L ? lllllll[1] : lllllll[0];
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, lllllll[0], b.length);
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    private static void lIIllII() {
        lllllll = new int[3];
        SplitOutputStream.lllllll[0] = (220 + 118 - 193 + 78 ^ 120 + 31 - 25 + 65) & (173 + 72 - 203 + 184 ^ 123 + 29 - 33 + 11 ^ -" ".length());
        SplitOutputStream.lllllll[1] = " ".length();
        SplitOutputStream.lllllll[2] = 0xA8 ^ 0xA1;
    }

    public SplitOutputStream(File file) throws FileNotFoundException, ZipException {
        this(file, -1L);
    }
}

