/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.IOException;
import java.io.InputStream;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.BaseInputStream;

public class ZipInputStream
extends InputStream {
    private BaseInputStream is;
    private static final int[] lIIIIlll;

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, lIIIIlll[1], b.length);
    }

    public ZipInputStream(BaseInputStream is) {
        this.is = is;
    }

    @Override
    public void close() throws IOException {
        this.close(lIIIIlll[1]);
    }

    @Override
    public int read() throws IOException {
        int readByte = this.is.read();
        if (readByte != lIIIIlll[0]) {
            this.is.getUnzipEngine().updateCRC(readByte);
        }
        return readByte;
    }

    static {
        ZipInputStream.lIlIIlI();
    }

    public void close(boolean skipCRCCheck) throws IOException {
        try {
            this.is.close();
            if (!skipCRCCheck && this.is.getUnzipEngine() != null) {
                this.is.getUnzipEngine().checkCRC();
            }
        }
        catch (ZipException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readLen = this.is.read(b, off, len);
        if (readLen > 0 && this.is.getUnzipEngine() != null) {
            this.is.getUnzipEngine().updateCRC(b, off, readLen);
        }
        return readLen;
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    private static void lIlIIlI() {
        lIIIIlll = new int[2];
        ZipInputStream.lIIIIlll[0] = -" ".length();
        ZipInputStream.lIIIIlll[1] = "   ".length() & ~"   ".length();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }
}

