/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.util.InternalZipConstants;

public class Zip4jUtil {
    private static final int[] lIlIIlIl;

    public static byte[] convertCharset(String str) throws ZipException {
        try {
            byte[] converted = null;
            String charSet = Zip4jUtil.detectCharSet(str);
            converted = charSet.equals("Cp850") ? str.getBytes("Cp850") : (charSet.equals("UTF8") ? str.getBytes("UTF8") : str.getBytes());
            return converted;
        }
        catch (UnsupportedEncodingException err) {
            return str.getBytes();
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static void setFileHidden(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null. cannot set hidden file attribute");
        }
        if (!Zip4jUtil.isWindows()) {
            return;
        }
        if (file.exists()) {
            try {
                Runtime.getRuntime().exec("attrib +H \"" + file.getAbsolutePath() + "\"");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int getEncodedStringLength(String str) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(str)) {
            throw new ZipException("input string is null, cannot calculate encoded String length");
        }
        String charset = Zip4jUtil.detectCharSet(str);
        return Zip4jUtil.getEncodedStringLength(str, charset);
    }

    public static void setFileSystemMode(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null. cannot set archive file attribute");
        }
        if (!Zip4jUtil.isWindows()) {
            return;
        }
        if (file.exists()) {
            try {
                Runtime.getRuntime().exec("attrib +S \"" + file.getAbsolutePath() + "\"");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getAbsoluteFilePath(String filePath) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(filePath)) {
            throw new ZipException("filePath is null or empty, cannot get absolute file path");
        }
        File file = new File(filePath);
        return file.getAbsolutePath();
    }

    public static int getEncodedStringLength(String str, String charset) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(str)) {
            throw new ZipException("input string is null, cannot calculate encoded String length");
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(charset)) {
            throw new ZipException("encoding is not defined, cannot calculate string length");
        }
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = charset.equals("Cp850") ? ByteBuffer.wrap(str.getBytes("Cp850")) : (charset.equals("UTF8") ? ByteBuffer.wrap(str.getBytes("UTF8")) : ByteBuffer.wrap(str.getBytes(charset)));
        }
        catch (UnsupportedEncodingException e) {
            byteBuffer = ByteBuffer.wrap(str.getBytes());
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
        return byteBuffer.limit();
    }

    private static void llIIIIl() {
        lIlIIlIl = new int[17];
        Zip4jUtil.lIlIIlIl[0] = (0x3F ^ 0x28) & ~(0x99 ^ 0x8E);
        Zip4jUtil.lIlIIlIl[1] = " ".length();
        Zip4jUtil.lIlIIlIl[2] = 0xFFFFF7FE & 0xFBD;
        Zip4jUtil.lIlIIlIl[3] = 0xDE ^ 0xC7;
        Zip4jUtil.lIlIIlIl[4] = "  ".length();
        Zip4jUtil.lIlIIlIl[5] = 118 + 103 - 207 + 135 ^ 31 + 23 - -62 + 12;
        Zip4jUtil.lIlIIlIl[6] = 0x75 ^ 0x67 ^ (0xD2 ^ 0xC5);
        Zip4jUtil.lIlIIlIl[7] = 0x19 ^ 9;
        Zip4jUtil.lIlIIlIl[8] = 0x6C ^ 0x67;
        Zip4jUtil.lIlIIlIl[9] = 0x57 ^ 0x5B;
        Zip4jUtil.lIlIIlIl[10] = 0x4B ^ 0x51 ^ (4 ^ 0x13);
        Zip4jUtil.lIlIIlIl[11] = 125 + 29 - 19 + 40 ^ 137 + 161 - 290 + 168;
        Zip4jUtil.lIlIIlIl[12] = 0x35 ^ 0xA;
        Zip4jUtil.lIlIIlIl[13] = 0x3F ^ 4 ^ (0x4D ^ 0x79);
        Zip4jUtil.lIlIIlIl[14] = (0x1D ^ 0x2D) + (0xED ^ 0xBA) - (0xE0 ^ 0x80) + (0x5D ^ 5);
        Zip4jUtil.lIlIIlIl[15] = -" ".length();
        Zip4jUtil.lIlIIlIl[16] = 0x81 ^ 0x88;
    }

    public static long dosToJavaTme(int dosTime) {
        int sec = lIlIIlIl[4] * (dosTime & lIlIIlIl[11]);
        int min = dosTime >> lIlIIlIl[6] & lIlIIlIl[12];
        int hrs = dosTime >> lIlIIlIl[8] & lIlIIlIl[11];
        int day = dosTime >> lIlIIlIl[7] & lIlIIlIl[11];
        int mon = (dosTime >> lIlIIlIl[5] & lIlIIlIl[13]) - lIlIIlIl[1];
        int year = (dosTime >> lIlIIlIl[3] & lIlIIlIl[14]) + lIlIIlIl[2];
        Calendar cal = Calendar.getInstance();
        cal.set(year, mon, day, hrs, min, sec);
        return cal.getTime().getTime();
    }

    public static boolean checkArrayListTypes(ArrayList sourceList, int type) throws ZipException {
        if (sourceList == null) {
            throw new ZipException("input arraylist is null, cannot check types");
        }
        if (sourceList.size() <= 0) {
            return lIlIIlIl[1];
        }
        int invalidFound = lIlIIlIl[0];
        block0 : switch (type) {
            case 1: {
                for (int i = lIlIIlIl[0]; i < sourceList.size(); ++i) {
                    if (sourceList.get(i) instanceof File) continue;
                    invalidFound = lIlIIlIl[1];
                    break block0;
                }
                break;
            }
            case 2: {
                for (int i = lIlIIlIl[0]; i < sourceList.size(); ++i) {
                    if (sourceList.get(i) instanceof String) continue;
                    invalidFound = lIlIIlIl[1];
                    break block0;
                }
                break;
            }
        }
        return invalidFound == 0 ? lIlIIlIl[1] : lIlIIlIl[0];
    }

    public static ArrayList getFilesInDirectoryRec(File path, boolean readHiddenFiles) throws ZipException {
        if (path == null) {
            throw new ZipException("input path is null, cannot read files in the directory");
        }
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = path.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        if (!path.canRead()) {
            return result;
        }
        for (int i = lIlIIlIl[0]; i < filesDirs.size(); ++i) {
            File file = filesDirs.get(i);
            if (file.isHidden() && !readHiddenFiles) {
                return result;
            }
            result.add(file);
            if (!file.isDirectory()) continue;
            ArrayList deeperList = Zip4jUtil.getFilesInDirectoryRec(file, readHiddenFiles);
            result.addAll(deeperList);
        }
        return result;
    }

    public static long getLocalTimeFromDSTTime(TimeZone timeZone, long time) throws ZipException {
        try {
            if (timeZone == null) {
                timeZone = TimeZone.getDefault();
            }
            if (timeZone != null && timeZone.getDSTSavings() > 0) {
                time += (long)(timeZone.getOffset(time) - timeZone.getDSTSavings());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return time;
    }

    public static int getIndexOfFileHeader(ZipModel zipModel, FileHeader fileHeader) throws ZipException {
        if (zipModel == null || fileHeader == null) {
            throw new ZipException("input parameters is null, cannot determine index of file header");
        }
        if (zipModel.getCentralDirectory() == null) {
            throw new ZipException("central directory is null, ccannot determine index of file header");
        }
        if (zipModel.getCentralDirectory().getFileHeaders() == null) {
            throw new ZipException("file Headers are null, cannot determine index of file header");
        }
        if (zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return lIlIIlIl[15];
        }
        String fileName = fileHeader.getFileName();
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            throw new ZipException("file name in file header is empty or null, cannot determine index of file header");
        }
        ArrayList fileHeaders = zipModel.getCentralDirectory().getFileHeaders();
        for (int i = lIlIIlIl[0]; i < fileHeaders.size(); ++i) {
            FileHeader fileHeaderTmp = (FileHeader)fileHeaders.get(i);
            String fileNameForHdr = fileHeaderTmp.getFileName();
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileNameForHdr) || !fileName.equalsIgnoreCase(fileNameForHdr)) continue;
            return i;
        }
        return lIlIIlIl[15];
    }

    public static String detectCharSet(String str) throws ZipException {
        if (str == null) {
            throw new ZipException("input string is null, cannot detect charset");
        }
        try {
            byte[] byteString = str.getBytes("Cp850");
            String tempString = new String(byteString, "Cp850");
            if (str.equals(tempString)) {
                return "Cp850";
            }
            byteString = str.getBytes("UTF8");
            tempString = new String(byteString, "UTF8");
            if (str.equals(tempString)) {
                return "UTF8";
            }
            return InternalZipConstants.CHARSET_DEFAULT;
        }
        catch (UnsupportedEncodingException e) {
            return InternalZipConstants.CHARSET_DEFAULT;
        }
        catch (Exception e) {
            return InternalZipConstants.CHARSET_DEFAULT;
        }
    }

    public static long javaToDosTime(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        int year = cal.get(lIlIIlIl[1]);
        if (year < lIlIIlIl[2]) {
            return 0x210000L;
        }
        return year - lIlIIlIl[2] << lIlIIlIl[3] | cal.get(lIlIIlIl[4]) + lIlIIlIl[1] << lIlIIlIl[5] | cal.get(lIlIIlIl[6]) << lIlIIlIl[7] | cal.get(lIlIIlIl[8]) << lIlIIlIl[8] | cal.get(lIlIIlIl[9]) << lIlIIlIl[6] | cal.get(lIlIIlIl[10]) >> lIlIIlIl[1];
    }

    public static void setFileArchive(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null. cannot set archive file attribute");
        }
        if (!Zip4jUtil.isWindows()) {
            return;
        }
        if (file.exists()) {
            try {
                if (file.isDirectory()) {
                    Runtime.getRuntime().exec("attrib +A \"" + file.getAbsolutePath() + "\"");
                } else {
                    Runtime.getRuntime().exec("attrib +A \"" + file.getAbsolutePath() + "\"");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static long getFileLengh(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null, cannot calculate file length");
        }
        if (file.isDirectory()) {
            return -1L;
        }
        return file.length();
    }

    public static String getZipFileNameWithoutExt(String zipFile) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(zipFile)) {
            throw new ZipException("zip file name is empty or null, cannot determine zip file name");
        }
        String tmpFileName = zipFile;
        if (zipFile.indexOf(System.getProperty("file.separator")) >= 0) {
            tmpFileName = zipFile.substring(zipFile.lastIndexOf(System.getProperty("file.separator")));
        }
        if (tmpFileName.indexOf(".") > 0) {
            tmpFileName = tmpFileName.substring(lIlIIlIl[0], tmpFileName.indexOf("."));
        }
        return tmpFileName;
    }

    static {
        Zip4jUtil.llIIIIl();
    }

    public static String getRelativeFileName(String file, String rootFolderInZip, String rootFolderPath) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(file)) {
            throw new ZipException("input file path/name is empty, cannot calculate relative file name");
        }
        String fileName = null;
        if (Zip4jUtil.isStringNotNullAndNotEmpty(rootFolderPath)) {
            File tmpFile;
            String tmpFileName = file.substring(rootFolderPath.length());
            if (tmpFileName.startsWith(System.getProperty("file.separator"))) {
                tmpFileName = tmpFileName.substring(lIlIIlIl[1]);
            }
            if ((tmpFile = new File(file)).isDirectory()) {
                tmpFileName = tmpFileName.replaceAll("\\\\", "/");
                tmpFileName = tmpFileName + "/";
            } else {
                String bkFileName = tmpFileName.substring(lIlIIlIl[0], tmpFileName.indexOf(tmpFile.getName()));
                bkFileName = bkFileName.replaceAll("\\\\", "/");
                tmpFileName = bkFileName + tmpFile.getName();
            }
            fileName = tmpFileName;
        } else {
            File relFile = new File(file);
            fileName = relFile.isDirectory() ? relFile.getName() + "/" : Zip4jUtil.getFileNameFromFilePath(new File(file));
        }
        if (Zip4jUtil.isStringNotNullAndNotEmpty(rootFolderInZip)) {
            fileName = rootFolderInZip + fileName;
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            throw new ZipException("Error determining file name");
        }
        return fileName;
    }

    public static boolean checkFileReadAccess(String path) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(path)) {
            throw new ZipException("path is null");
        }
        if (!Zip4jUtil.checkFileExists(path)) {
            throw new ZipException("zip file does not exist");
        }
        try {
            File file = new File(path);
            return file.canRead();
        }
        catch (Exception e) {
            throw new ZipException("cannot read zip file");
        }
    }

    public static FileHeader getFileHeader(ZipModel zipModel, String fileName) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot determine file header for fileName: " + fileName);
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            throw new ZipException("file name is null, cannot determine file header for fileName: " + fileName);
        }
        FileHeader fileHeader = null;
        fileHeader = Zip4jUtil.getFileHeaderWithExactMatch(zipModel, fileName);
        if (fileHeader == null && (fileHeader = Zip4jUtil.getFileHeaderWithExactMatch(zipModel, fileName = fileName.replaceAll("\\\\", "/"))) == null) {
            fileName = fileName.replaceAll("/", "\\\\");
            fileHeader = Zip4jUtil.getFileHeaderWithExactMatch(zipModel, fileName);
        }
        return fileHeader;
    }

    public static boolean isStringNotNullAndNotEmpty(String str) {
        if (str == null || str.trim().length() <= 0) {
            return lIlIIlIl[0];
        }
        return lIlIIlIl[1];
    }

    public static String decodeFileName(byte[] data, boolean isUTF8) {
        if (isUTF8) {
            try {
                return new String(data, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(data);
            }
        }
        return Zip4jUtil.getCp850EncodedString(data);
    }

    public static String getFileNameFromFilePath(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null, cannot get file name");
        }
        if (file.isDirectory()) {
            return null;
        }
        return file.getName();
    }

    public static String getCp850EncodedString(byte[] data) {
        try {
            String retString = new String(data, "Cp850");
            return retString;
        }
        catch (UnsupportedEncodingException e) {
            return new String(data);
        }
    }

    public static boolean isSupportedCharset(String charset) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(charset)) {
            throw new ZipException("charset is null or empty, cannot check if it is supported");
        }
        try {
            new String("a".getBytes(), charset);
            return lIlIIlIl[1];
        }
        catch (UnsupportedEncodingException e) {
            return lIlIIlIl[0];
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static boolean checkFileWriteAccess(String path) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(path)) {
            throw new ZipException("path is null");
        }
        if (!Zip4jUtil.checkFileExists(path)) {
            throw new ZipException("zip file does not exist");
        }
        try {
            File file = new File(path);
            return file.canWrite();
        }
        catch (Exception e) {
            throw new ZipException("cannot read zip file");
        }
    }

    public static boolean checkFileExists(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("cannot check if file exists: input file is null");
        }
        return file.exists();
    }

    public static long getFileLengh(String file) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(file)) {
            throw new ZipException("invalid file name");
        }
        return Zip4jUtil.getFileLengh(new File(file));
    }

    public static long getLastModifiedFileTime(File file, TimeZone timeZone) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null, cannot read last modified file time");
        }
        if (!file.exists()) {
            throw new ZipException("input file does not exist, cannot read last modified file time");
        }
        return Zip4jUtil.getDayLightSavingsTime(timeZone, file.lastModified());
    }

    public static boolean checkOutputFolder(String path) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(path)) {
            throw new ZipException(new NullPointerException("output path is null"));
        }
        File file = new File(path);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new ZipException("output folder is not valid");
            }
            if (!file.canWrite()) {
                throw new ZipException("no write access to output folder");
            }
        } else {
            try {
                file.mkdirs();
                if (!file.isDirectory()) {
                    throw new ZipException("output folder is not valid");
                }
                if (!file.canWrite()) {
                    throw new ZipException("no write access to destination folder");
                }
            }
            catch (Exception e) {
                throw new ZipException("Cannot create destination folder");
            }
        }
        return lIlIIlIl[1];
    }

    public static ArrayList getSplitZipFiles(ZipModel zipModel) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("cannot get split zip files: zipmodel is null");
        }
        if (zipModel.getEndCentralDirRecord() == null) {
            return null;
        }
        ArrayList<String> retList = new ArrayList<String>();
        String currZipFile = zipModel.getZipFile();
        String partFile = null;
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(currZipFile)) {
            throw new ZipException("cannot get split zip files: zipfile is null");
        }
        if (!zipModel.isSplitArchive()) {
            retList.add(currZipFile);
            return retList;
        }
        int numberOfThisDisk = zipModel.getEndCentralDirRecord().getNoOfThisDisk();
        if (numberOfThisDisk == 0) {
            retList.add(currZipFile);
            return retList;
        }
        for (int i = lIlIIlIl[0]; i <= numberOfThisDisk; ++i) {
            if (i == numberOfThisDisk) {
                retList.add(zipModel.getZipFile());
                continue;
            }
            partFile = i >= lIlIIlIl[16] ? currZipFile.substring(lIlIIlIl[0], currZipFile.lastIndexOf(".")) + ".z" + (i + lIlIIlIl[1]) : currZipFile.substring(lIlIIlIl[0], currZipFile.lastIndexOf(".")) + ".z0" + (i + lIlIIlIl[1]);
            retList.add(partFile);
        }
        return retList;
    }

    public static boolean checkFileExists(String path) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(path)) {
            throw new ZipException("path is null");
        }
        File file = new File(path);
        return Zip4jUtil.checkFileExists(file);
    }

    private static long getDayLightSavingsTime(TimeZone timeZone, long time) throws ZipException {
        try {
            if (timeZone == null) {
                timeZone = TimeZone.getDefault();
            }
            if (timeZone != null && timeZone.getDSTSavings() > 0) {
                time -= (long)(timeZone.getOffset(time) - timeZone.getDSTSavings());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return time;
    }

    public static void setFileReadOnly(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null. cannot set read only file attribute");
        }
        if (file.exists()) {
            file.setReadOnly();
        }
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0 ? lIlIIlIl[1] : lIlIIlIl[0];
    }

    public static FileHeader getFileHeaderWithExactMatch(ZipModel zipModel, String fileName) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot determine file header with exact match for fileName: " + fileName);
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            throw new ZipException("file name is null, cannot determine file header with exact match for fileName: " + fileName);
        }
        if (zipModel.getCentralDirectory() == null) {
            throw new ZipException("central directory is null, cannot determine file header with exact match for fileName: " + fileName);
        }
        if (zipModel.getCentralDirectory().getFileHeaders() == null) {
            throw new ZipException("file Headers are null, cannot determine file header with exact match for fileName: " + fileName);
        }
        if (zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return null;
        }
        ArrayList fileHeaders = zipModel.getCentralDirectory().getFileHeaders();
        for (int i = lIlIIlIl[0]; i < fileHeaders.size(); ++i) {
            FileHeader fileHeader = (FileHeader)fileHeaders.get(i);
            String fileNameForHdr = fileHeader.getFileName();
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileNameForHdr) || !fileName.equalsIgnoreCase(fileNameForHdr)) continue;
            return fileHeader;
        }
        return null;
    }
}

