/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.api;

import com.google.common.collect.Maps;
import fr.nathanael2611.modularvoicechat.api.VoiceProperties;
import fr.nathanael2611.modularvoicechat.network.objects.VoiceToClient;
import fr.nathanael2611.modularvoicechat.server.VoiceServer;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class VoiceDispatchEvent
extends PlayerEvent {
    private HashMap<EntityPlayerMP, VoiceToClient> hearList = Maps.newHashMap();
    private EntityPlayerMP speaker;
    private VoiceServer voiceServer;
    private byte[] voiceData;
    private VoiceProperties properties;

    public VoiceDispatchEvent(VoiceServer server, EntityPlayerMP speaker, byte[] voiceData, VoiceProperties properties) {
        super((EntityPlayer)speaker);
        this.speaker = speaker;
        this.voiceServer = server;
        this.voiceData = voiceData;
        this.properties = properties;
    }

    public EntityPlayerMP getSpeaker() {
        return this.speaker;
    }

    public boolean isCancelable() {
        return true;
    }

    public VoiceServer getVoiceServer() {
        return this.voiceServer;
    }

    public VoiceProperties getProperties() {
        return this.properties;
    }

    public void setProperties(VoiceProperties properties) {
        this.properties = properties;
    }

    private VoiceToClient getPacket(int volume, VoiceProperties properties) {
        return new VoiceToClient(this.getEntityPlayer().func_145782_y(), this.voiceData, volume, properties);
    }

    private VoiceToClient getPacket(int volume) {
        return this.getPacket(volume, VoiceProperties.empty());
    }

    public void dispatchTo(EntityPlayerMP playerMP) {
        this.dispatchTo(playerMP, 100);
    }

    public void dispatchTo(EntityPlayerMP playerMP, int voiceVolume) {
        this.dispatchTo(playerMP, voiceVolume, VoiceProperties.empty());
    }

    public void dispatchTo(EntityPlayerMP playerMP, int voiceVolume, VoiceProperties properties) {
        this.dispatchTo(playerMP, voiceVolume, properties, false);
    }

    public void dispatchTo(EntityPlayerMP playerMP, int voiceVolume, VoiceProperties properties, boolean forceOverride) {
        VoiceToClient packet = this.getPacket(voiceVolume, properties);
        if (!forceOverride && this.hearList.containsKey(playerMP) && voiceVolume < this.hearList.get((Object)playerMP).volumePercent) {
            return;
        }
        this.hearList.put(playerMP, packet);
    }

    public void dispatchToAllExceptSpeaker() {
        this.dispatchToAllExceptSpeaker(100);
    }

    public void dispatchToAllExceptSpeaker(int voiceVolume) {
        this.dispatchToAllExceptSpeaker(voiceVolume, VoiceProperties.empty());
    }

    public void dispatchToAllExceptSpeaker(int voiceVolume, VoiceProperties properties) {
        this.dispatchToAllExceptSpeaker(voiceVolume, properties, false);
    }

    public void dispatchToAllExceptSpeaker(int voiceVolume, VoiceProperties properties, boolean forceOverride) {
        for (EntityPlayerMP connectedPlayer : this.voiceServer.getConnectedPlayers()) {
            this.dispatchTo(connectedPlayer, voiceVolume, properties, forceOverride);
        }
    }

    public void finalizeDispatch() {
        this.hearList.forEach((player, packet) -> this.voiceServer.send((EntityPlayerMP)player, packet));
    }
}

