/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.audio.speaker;

import fr.nathanael2611.modularvoicechat.api.VoicePlayEvent;
import fr.nathanael2611.modularvoicechat.api.VoiceProperties;
import fr.nathanael2611.modularvoicechat.audio.api.IAudioDecoder;
import fr.nathanael2611.modularvoicechat.audio.api.NoExceptionCloseable;
import fr.nathanael2611.modularvoicechat.audio.impl.OpusDecoder;
import fr.nathanael2611.modularvoicechat.audio.speaker.SpeakerBuffer;
import fr.nathanael2611.modularvoicechat.audio.speaker.SpeakerData;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SpeakerBufferPusher
implements NoExceptionCloseable {
    private final SpeakerBuffer buffer = new SpeakerBuffer(10);
    private final IAudioDecoder decoder = new OpusDecoder(4800, 2, 20, 1000);
    private final Future<?> future;

    public SpeakerBufferPusher(ExecutorService executor, int id, SpeakerData speakerData) {
        this.future = executor.submit(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                if (!speakerData.isAvailable(id) || speakerData.freeBuffer(id) <= 0) continue;
                SpeakerBuffer.AudioEntry entry = this.buffer.getNextPacket();
                if (entry.isEnd()) {
                    speakerData.flush(id);
                    continue;
                }
                VoicePlayEvent event = new VoicePlayEvent(entry.getPacket(), entry.getVolumePercent(), entry.getProperties());
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) continue;
                speakerData.write(id, event.getAudioSamples(), event.getVolumePercent());
            }
        });
    }

    public void decodePush(byte[] opusPacket, int volumePercent, VoiceProperties properties) {
        this.push(this.decoder.decoder(opusPacket), volumePercent, properties);
    }

    private void push(byte[] packet, int volumePercent, VoiceProperties properties) {
        this.buffer.pushPacket(packet, volumePercent, properties);
    }

    public void end() {
        this.buffer.pushEnd();
    }

    @Override
    public void close() {
        this.future.cancel(true);
        this.decoder.close();
    }
}

