/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.audio.speaker;

import fr.nathanael2611.modularvoicechat.util.AudioUtil;
import javax.sound.sampled.SourceDataLine;

public class SpeakerLineInfo {
    private final SourceDataLine line;
    private long lastAccessed;
    private boolean masterVolumeControlFound;
    private int multiplier;

    public SpeakerLineInfo(SourceDataLine line) {
        this.line = line;
        this.lastAccessed = System.currentTimeMillis();
    }

    public void setMasterVolume(int volume) {
        this.multiplier = AudioUtil.calculateVolumeMultiplier(volume);
    }

    public SourceDataLine getSourceDataLine() {
        this.lastAccessed = System.currentTimeMillis();
        return this.line;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public boolean isMasterVolumeControlFound() {
        return this.masterVolumeControlFound;
    }

    public int getMultiplier() {
        return this.multiplier;
    }
}

