/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.client;

import fr.nathanael2611.modularvoicechat.api.VoiceKeyEvent;
import fr.nathanael2611.modularvoicechat.client.SpeakingPlayers;
import fr.nathanael2611.modularvoicechat.client.gui.GuiConfig;
import fr.nathanael2611.modularvoicechat.client.voice.VoiceClientManager;
import fr.nathanael2611.modularvoicechat.client.voice.audio.MicroManager;
import fr.nathanael2611.modularvoicechat.client.voice.audio.SpeakerManager;
import fr.nathanael2611.modularvoicechat.config.ClientConfig;
import fr.nathanael2611.modularvoicechat.proxy.ClientProxy;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClientEventHandler {
    public static final ResourceLocation MICRO = new ResourceLocation("modularvc", "textures/micro.png");
    public static boolean showWhoSpeak = false;
    private Minecraft mc;
    private float alpha = 0.3f;

    public ClientEventHandler(Minecraft minecraft) {
        this.mc = minecraft;
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof GuiIngameMenu && MicroManager.isRunning() && SpeakerManager.isRunning()) {
            event.getButtonList().add(new GuiButton(434, event.getGui().field_146294_l / 2 - 100, 0, "ModularVoiceChat"));
        }
    }

    @SubscribeEvent
    public void onGuiActionPerformed(GuiScreenEvent.ActionPerformedEvent event) {
        if (event.getGui() instanceof GuiIngameMenu && event.getButton().field_146127_k == 434) {
            this.mc.func_147108_a((GuiScreen)new GuiConfig());
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ScaledResolution resolution = event.getResolution();
            if (VoiceClientManager.isStarted() && MicroManager.isRunning() && VoiceClientManager.getClient().isConnected()) {
                if (!GuiConfig.audioTesting) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(resolution.func_78326_a() - 32), (float)(resolution.func_78328_b() - 32), (float)0.0f);
                    this.alpha = Math.max(0.0f, Math.min(1.0f, MicroManager.getHandler().isSending() ? this.alpha + 0.1f : this.alpha - 0.05f));
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                    GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
                    this.mc.func_110434_K().func_110577_a(MICRO);
                    Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
                    GlStateManager.func_179121_F();
                }
            } else {
                this.mc.field_71466_p.func_175063_a(String.format("\u00a7c[%s] %s", "ModularVoiceChat", I18n.func_135052_a((String)"mvc.error.notconnected", (Object[])new Object[0])), 2.0f, 2.0f, Color.WHITE.getRGB());
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        if (this.mc.field_71474_y.field_74319_N || !showWhoSpeak) {
            return;
        }
        boolean flag = SpeakingPlayers.isTalking(event.getEntityPlayer());
        if (flag) {
            float factor = 0.01f;
            double scale = 1.5;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)event.getX(), (double)(event.getY() + (event.getEntityPlayer().func_70093_af() ? 2.4 : 2.5)), (double)event.getZ());
            GlStateManager.func_187432_a((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179139_a((double)((double)-0.01f * scale), (double)((double)-0.01f * scale), (double)((double)-0.01f * scale));
            GlStateManager.func_179114_b((float)(-this.mc.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.mc.func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            this.mc.func_110434_K().func_110577_a(MICRO);
            Gui.func_146110_a((int)-16, (int)-16, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (this.mc.field_71439_g == null && this.mc.field_71441_e == null) {
                if (SpeakerManager.isRunning()) {
                    SpeakerManager.stop();
                }
                if (MicroManager.isRunning()) {
                    MicroManager.stop();
                }
                if (VoiceClientManager.isStarted()) {
                    VoiceClientManager.stop();
                }
            }
            if (ClientProxy.KEY_OPEN_CONFIG.func_151468_f() && MicroManager.isRunning() && SpeakerManager.isRunning()) {
                this.mc.func_147108_a((GuiScreen)new GuiConfig());
            } else if (!GuiConfig.audioTesting) {
                VoiceKeyEvent voiceKeyEvent = new VoiceKeyEvent(ClientProxy.getConfig().get(ClientConfig.TOGGLE_TO_TALK).getAsBoolean());
                MinecraftForge.EVENT_BUS.post((Event)voiceKeyEvent);
                if (!voiceKeyEvent.isCanceled()) {
                    if (voiceKeyEvent.isToggleToTalk()) {
                        if (ClientProxy.KEY_SPEAK.func_151468_f()) {
                            if (MicroManager.isRunning() && !MicroManager.getHandler().isSending()) {
                                MicroManager.getHandler().start();
                            } else if (MicroManager.isRunning() && MicroManager.getHandler().isSending()) {
                                MicroManager.getHandler().stop();
                            }
                        }
                    } else if (GameSettings.func_100015_a((KeyBinding)ClientProxy.KEY_SPEAK)) {
                        if (MicroManager.isRunning() && !MicroManager.getHandler().isSending()) {
                            MicroManager.getHandler().start();
                        }
                    } else if (MicroManager.isRunning() && MicroManager.getHandler().isSending()) {
                        MicroManager.getHandler().stop();
                    }
                }
            }
        }
    }
}

