/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.config;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import fr.nathanael2611.modularvoicechat.config.ConfigProperty;
import fr.nathanael2611.modularvoicechat.config.GameConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MutedPlayers
extends GameConfig {
    public static final ConfigProperty MUTED_PLAYERS = new ConfigProperty("muted-players", (JsonElement)new JsonArray());

    public MutedPlayers(File config) {
        super(config);
        if (!config.exists()) {
            try {
                config.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isMuted(String playerName) {
        for (JsonElement element : this.get(MUTED_PLAYERS).getAsJsonArray()) {
            if (!element.getAsString().equalsIgnoreCase(playerName)) continue;
            return true;
        }
        return false;
    }

    public void setMute(String playerName, boolean muted) {
        JsonArray array = this.get(MUTED_PLAYERS).getAsJsonArray();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement element = array.get(i);
            if (!element.getAsString().equalsIgnoreCase(playerName)) continue;
            array.remove(element);
        }
        if (muted) {
            array.add(playerName);
        }
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void read() throws IOException {
        super.read();
        this.initProperty(MUTED_PLAYERS);
    }

    public List<String> getNames() {
        ArrayList list = Lists.newArrayList();
        for (JsonElement element : this.get(MUTED_PLAYERS).getAsJsonArray()) {
            list.add(element.getAsString());
        }
        return list;
    }
}

