/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements;

import java.util.ArrayList;
import java.util.List;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiDelegateElement;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiElements;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDrawable;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.Keybind;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Direction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class GuiPanelBase<T extends GuiElement>
extends GuiElement {
    public GuiDelegateElement<T> view;
    public GuiElements<GuiIconElement> buttons;
    public List<T> panels = new ArrayList<T>();
    public Direction direction;

    public GuiPanelBase(Minecraft mc) {
        this(mc, Direction.BOTTOM);
    }

    public GuiPanelBase(Minecraft mc, Direction direction) {
        super(mc);
        this.direction = direction == null ? Direction.BOTTOM : direction;
        this.view = new GuiDelegateElement<Object>(mc, null);
        this.view.flex().relative(this).w(1.0f).h(1.0f, -20);
        if (this.direction == Direction.TOP) {
            this.view.flex().y(20);
        } else if (this.direction == Direction.LEFT) {
            this.view.flex().x(20).w(1.0f, -20).h(1.0f, 0);
        } else if (this.direction == Direction.RIGHT) {
            this.view.flex().w(1.0f, -20).h(1.0f, 0);
        }
        this.buttons = new GuiElements(this);
        this.add(this.view, new GuiDrawable(this::drawOverlay), this.buttons);
    }

    public GuiIconElement getButton(T panel) {
        int index = this.panels.indexOf(panel);
        return index < 0 ? null : (GuiIconElement)this.buttons.elements.get(index);
    }

    public GuiIconElement registerPanel(T panel, IKey tooltip, Icon icon) {
        GuiIconElement button = new GuiIconElement(this.mc, icon, b -> this.setPanel(panel));
        if (tooltip != null && !tooltip.get().isEmpty()) {
            button.tooltip(tooltip, this.direction.opposite());
        }
        ((GuiElement)panel).markContainer();
        this.setupButtonResizer(button);
        this.panels.add(panel);
        this.buttons.add(button);
        return button;
    }

    public Keybind registerKeybind(GuiIconElement element, IKey label, int key) {
        return this.keys().register(label, key, () -> element.clickItself(GuiBase.getCurrent()));
    }

    protected void setupButtonResizer(GuiIconElement button) {
        if (this.buttons.elements.isEmpty()) {
            if (this.direction.isHorizontal()) {
                button.flex().relative(this).set(2.0f, 2.0f, 16.0f, 16.0f);
                if (this.direction == Direction.RIGHT) {
                    button.flex().x(1.0f, -18);
                }
            } else {
                boolean bottom = this.direction == Direction.BOTTOM;
                button.flex().relative(this).set(0.0f, 0.0f, 16.0f, 16.0f).x(1.0f, -18).y(bottom ? 1.0f : 0.0f, bottom ? -18 : 2);
            }
        } else {
            GuiIconElement last = (GuiIconElement)this.buttons.elements.get(this.buttons.elements.size() - 1);
            int x = this.direction.isVertical() ? -20 : 0;
            int y = this.direction.isHorizontal() ? 20 : 0;
            button.flex().relative(last).set(x, y, 16.0f, 16.0f);
        }
    }

    public void setPanel(T panel) {
        this.view.setDelegate(panel);
    }

    protected void drawOverlay(GuiContext context) {
        if (this.direction == Direction.TOP) {
            this.drawBackground(context, this.area.x, this.area.y, this.area.w, 20);
        } else if (this.direction == Direction.BOTTOM) {
            this.drawBackground(context, this.area.x, this.area.ey() - 20, this.area.w, 20);
        } else if (this.direction == Direction.LEFT) {
            this.drawBackground(context, this.area.x, this.area.y, 20, this.area.h);
        } else {
            this.drawBackground(context, this.area.ex() - 20, this.area.y, 20, this.area.h);
        }
        int c = this.panels.size();
        for (int i = 0; i < c; ++i) {
            if (this.view.delegate != this.panels.get(i)) continue;
            Area area = ((GuiIconElement)this.buttons.elements.get((int)i)).area;
            Gui.func_73734_a((int)(area.x - 2), (int)(area.y - 2), (int)(area.ex() + 2), (int)(area.ey() + 2), (int)(-1442840576 + McLib.primaryColor.get()));
        }
    }

    protected void drawBackground(GuiContext context, int x, int y, int w, int h) {
    }
}

