/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.context;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public class GuiSimpleContextMenu
extends GuiContextMenu {
    public GuiListElement<Action> actions;
    private boolean shadow;

    public GuiSimpleContextMenu(Minecraft mc) {
        super(mc);
        this.actions = new GuiActionListElement(mc, action -> {
            if (((Action)action.get((int)0)).runnable != null) {
                ((Action)action.get((int)0)).runnable.run();
            }
            this.removeFromParent();
        });
        this.actions.flex().relative(this).w(1.0f, 0).h(1.0f, 0);
        this.add((IGuiElement)this.actions);
    }

    public GuiSimpleContextMenu shadow() {
        this.shadow = true;
        return this;
    }

    public GuiSimpleContextMenu action(IKey label, Runnable runnable) {
        return this.action(Icons.NONE, label, runnable);
    }

    public GuiSimpleContextMenu action(Icon icon, IKey label, Runnable runnable) {
        if (icon == null || label == null) {
            return this;
        }
        return this.action(new Action(icon, label, runnable));
    }

    public GuiSimpleContextMenu action(Icon icon, IKey label, Runnable runnable, int color) {
        if (icon == null || label == null) {
            return this;
        }
        return this.action(new ColorfulAction(icon, label, runnable, color));
    }

    public GuiSimpleContextMenu action(Action action) {
        this.actions.add(action);
        return this;
    }

    @Override
    public void setMouse(GuiContext context) {
        int w = 100;
        for (Action action : this.actions.getList()) {
            w = Math.max(action.getWidth(this.font), w);
        }
        Supplier<Float> h = () -> Float.valueOf(Math.min(this.actions.scroll.scrollSize, context.screen.field_146295_m - 10));
        this.flex().set(context.mouseX(), context.mouseY(), w, 0.0f).h(h).bounds(context.screen.root, 5);
    }

    @Override
    public void draw(GuiContext context) {
        if (this.shadow) {
            int color = McLib.primaryColor.get();
            GuiDraw.drawDropShadow(this.area.x, this.area.y, this.area.ex(), this.area.ey(), 10, 0x44000000 + color, color);
        }
        super.draw(context);
    }

    public static class ColorfulAction
    extends Action {
        public int color;

        public ColorfulAction(Icon icon, IKey label, Runnable runnable, int color) {
            super(icon, label, runnable);
            this.color = color;
        }

        @Override
        protected void drawBackground(FontRenderer font, int x, int y, int w, int h, boolean hover, boolean selected) {
            super.drawBackground(font, x, y, w, h, hover, selected);
            Gui.func_73734_a((int)x, (int)y, (int)(x + 2), (int)(y + h), (int)(-16777216 + this.color));
            GuiDraw.drawHorizontalGradientRect(x + 2, y, x + 24, y + h, 0x44000000 + this.color, this.color);
        }
    }

    public static class Action {
        public Icon icon;
        public IKey label;
        public Runnable runnable;

        public Action(Icon icon, IKey label, Runnable runnable) {
            this.icon = icon;
            this.label = label;
            this.runnable = runnable;
        }

        public int getWidth(FontRenderer font) {
            return 28 + font.func_78256_a(this.label.get());
        }

        public void draw(FontRenderer font, int x, int y, int w, int h, boolean hover, boolean selected) {
            this.drawBackground(font, x, y, w, h, hover, selected);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.icon.render(x + 2, y + h / 2, 0.0f, 0.5f);
            font.func_78276_b(this.label.get(), x + 22, y + (h - font.field_78288_b) / 2 + 1, 0xFFFFFF);
        }

        protected void drawBackground(FontRenderer font, int x, int y, int w, int h, boolean hover, boolean selected) {
            if (hover) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)(-2013265920 + McLib.primaryColor.get()));
            }
        }
    }

    public static class GuiActionListElement
    extends GuiListElement<Action> {
        public GuiActionListElement(Minecraft mc, Consumer<List<Action>> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 20;
        }

        @Override
        public void drawListElement(Action element, int i, int x, int y, boolean hover, boolean selected) {
            int h = this.scroll.scrollItemSize;
            element.draw(this.font, x, y, this.scroll.w, h, hover, selected);
        }
    }
}

