/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.input;

import com.google.common.base.Predicate;
import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.elements.input.GuiBaseTextElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.ITextColoring;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.values.ValueString;
import mchorse.mclib.utils.Patterns;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTextElement
extends GuiBaseTextElement
implements GuiPageButtonList.GuiResponder,
ITextColoring {
    public static final Predicate<String> FILENAME_PREDICATE = s -> Patterns.FILENAME.matcher((CharSequence)s).find();
    public Consumer<String> callback;

    public GuiTextElement(Minecraft mc, ValueString value) {
        this(mc, value, null);
    }

    public GuiTextElement(Minecraft mc, ValueString value, Consumer<String> callback) {
        this(mc, callback == null ? value::set : string -> {
            value.set((String)string);
            callback.accept((String)string);
        });
        this.setText(value.get());
        this.tooltip(IKey.lang(value.getConfig().getValueLabelKey(value)));
    }

    public GuiTextElement(Minecraft mc, int maxLength, Consumer<String> callback) {
        this(mc, callback);
        this.field.func_146203_f(maxLength);
    }

    public GuiTextElement(Minecraft mc, Consumer<String> callback) {
        super(mc);
        this.field.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.callback = callback;
        this.flex().h(20);
    }

    public GuiTextElement filename() {
        return this.validator(FILENAME_PREDICATE);
    }

    public GuiTextElement validator(Predicate<String> validator) {
        this.field.func_175205_a(validator);
        return this;
    }

    public GuiTextElement background(boolean background) {
        this.field.func_146185_a(background);
        this.resize();
        return this;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.field.func_146180_a(text);
        this.field.func_146196_d();
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        if (this.callback != null) {
            this.callback.accept(value);
        }
    }

    @Override
    public void setColor(int color, boolean shadow) {
        this.field.func_146193_g(color);
    }

    @Override
    public void resize() {
        super.resize();
        this.field.field_146209_f = this.area.x + 1;
        this.field.field_146210_g = this.area.y + 1;
        this.field.field_146218_h = this.area.w - 2;
        this.field.field_146219_i = this.area.h - 2;
        if (!this.field.func_146181_i()) {
            this.field.field_146209_f += 4;
            this.field.field_146210_g += (this.area.h - this.font.field_78288_b) / 2;
            this.field.field_146218_h -= 8;
            this.field.field_146219_i = this.font.field_78288_b;
        }
    }

    @Override
    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        boolean wasFocused = this.field.func_146206_l();
        this.field.func_146192_a(context.mouseX, context.mouseY, context.mouseButton);
        if (wasFocused != this.field.func_146206_l()) {
            context.focus(wasFocused ? null : this);
        }
        return context.mouseButton == 0 && this.area.isInside(context);
    }

    @Override
    public boolean keyTyped(GuiContext context) {
        if (this.isFocused()) {
            if (context.keyCode == 15) {
                context.focus(this, -1, GuiScreen.func_146272_n() ? -1 : 1);
                return true;
            }
            if (context.keyCode == 1) {
                context.unfocus();
                return true;
            }
        }
        return this.field.func_146201_a(context.typedChar, context.keyCode) || super.keyTyped(context);
    }

    @Override
    public void draw(GuiContext context) {
        this.field.func_146194_f();
        GuiDraw.drawLockedArea(this);
        super.draw(context);
    }
}

