/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.utils;

import java.util.function.Supplier;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.ITextColoring;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;

public class GuiLabel
extends GuiElement
implements ITextColoring {
    public IKey label;
    public int color;
    public boolean textShadow = true;
    public float anchorX;
    public float anchorY;
    public int background;
    public Supplier<Integer> backgroundColor;

    public GuiLabel(Minecraft mc, IKey label) {
        this(mc, label, 0xFFFFFF);
    }

    public GuiLabel(Minecraft mc, IKey label, int color) {
        super(mc);
        this.label = label;
        this.color = color;
    }

    @Override
    public void setColor(int color, boolean shadow) {
        this.color(color, shadow);
    }

    public GuiLabel color(int color) {
        return this.color(color, true);
    }

    public GuiLabel color(int color, boolean textShadow) {
        this.textShadow = textShadow;
        this.color = color;
        return this;
    }

    public GuiLabel background() {
        return this.background(-2013265920);
    }

    public GuiLabel background(int color) {
        this.background = color;
        return this;
    }

    public GuiLabel background(Supplier<Integer> color) {
        this.backgroundColor = color;
        return this;
    }

    public GuiLabel anchor(float x, float y) {
        this.anchorX = x;
        this.anchorY = y;
        return this;
    }

    public int getColor() {
        return this.backgroundColor == null ? this.background : this.backgroundColor.get();
    }

    @Override
    public void draw(GuiContext context) {
        String label = this.label.get();
        int x = this.area.x(this.anchorX, this.font.func_78256_a(label));
        int y = this.area.y(this.anchorY, this.font.field_78288_b);
        GuiDraw.drawTextBackground(this.font, label, x, y, this.color, this.getColor(), 3, this.textShadow);
        super.draw(context);
    }
}

