/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.mclib;

import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.mclib.GuiDashboardPanel;
import mchorse.mclib.client.gui.mclib.GuiDashboardPanels;
import mchorse.mclib.client.gui.utils.Keybind;
import mchorse.mclib.events.RegisterDashboardPanels;
import mchorse.mclib.utils.OpHelper;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class GuiAbstractDashboard
extends GuiBase {
    public GuiDashboardPanels panels;
    public GuiDashboardPanel defaultPanel;
    private boolean wasClosed = true;
    private int opLevel = -1;

    public GuiAbstractDashboard(Minecraft mc) {
        this.panels = this.createDashboardPanels(mc);
        this.panels.flex().relative(this.viewport).wh(1.0f, 1.0f);
        this.registerPanels(mc);
        McLib.EVENT_BUS.post((Event)new RegisterDashboardPanels(this));
        this.root.add((IGuiElement)this.panels);
    }

    protected abstract GuiDashboardPanels createDashboardPanels(Minecraft var1);

    protected abstract void registerPanels(Minecraft var1);

    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void func_146281_b() {
        this.close();
        super.func_146281_b();
    }

    private void close() {
        this.panels.close();
        this.wasClosed = true;
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        this.updateOPAccess();
        if (this.wasClosed) {
            this.wasClosed = false;
            this.panels.open();
            this.panels.setPanel((GuiDashboardPanel)this.panels.view.delegate);
        }
        super.func_146280_a(mc, width, height);
    }

    private void updateOPAccess() {
        GuiDashboardPanel current;
        int newOpLevel = OpHelper.getPlayerOpLevel();
        if (newOpLevel != this.opLevel) {
            for (GuiDashboardPanel panel : this.panels.panels) {
                GuiIconElement button = this.panels.getButton(panel);
                boolean enabled = panel.canBeOpened(newOpLevel);
                button.setEnabled(enabled);
                for (Keybind keybind : this.panels.keys().keybinds) {
                    keybind.active(enabled);
                }
            }
        }
        if ((current = (GuiDashboardPanel)this.panels.view.delegate) != null && !current.canBeOpened(newOpLevel)) {
            this.panels.setPanel(this.defaultPanel);
        } else if (current == null) {
            this.panels.setPanel((GuiDashboardPanel)null);
        }
        this.opLevel = newOpLevel;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.panels.view.delegate != null && ((GuiDashboardPanel)this.panels.view.delegate).needsBackground()) {
            GuiDraw.drawCustomBackground(0, 0, this.field_146294_l, this.field_146295_m);
        } else {
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m / 8, 0x44000000, 0);
            this.func_73733_a(0, this.field_146295_m - this.field_146295_m / 8, this.field_146294_l, this.field_146295_m, 0, 0x44000000);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

