/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TabCompleter {
    protected GuiTextField textField;
    protected List<String> allCompletions = Lists.newArrayList();
    protected List<String> completions = Lists.newArrayList();
    protected boolean didComplete;
    protected int index;

    public TabCompleter(GuiTextField textField) {
        this.textField = textField;
    }

    public List<String> getCompletions() {
        return this.completions;
    }

    public GuiTextField getField() {
        return this.textField;
    }

    public void setField(GuiTextField textField) {
        this.textField = textField;
    }

    public void complete() {
        int size = this.completions.size();
        if (size != 0 && this.index >= 0 && this.index < size) {
            this.textField.func_146180_a(this.completions.get(this.index));
        }
        if (this.didComplete) {
            ++this.index;
            if (this.index >= this.completions.size()) {
                this.index = 0;
            }
        } else {
            this.requestCompletions(this.textField.func_146179_b());
        }
    }

    private void requestCompletions(String prefix) {
        ArrayList<String> completions = new ArrayList<String>();
        for (String str : this.allCompletions) {
            if (!str.toLowerCase().startsWith(prefix.toLowerCase()) && !prefix.isEmpty()) continue;
            completions.add(str);
        }
        this.setCompletions(completions);
    }

    public void setAllCompletions(List<String> words) {
        this.allCompletions.clear();
        this.allCompletions.addAll(words);
    }

    public void setCompletions(List<String> words) {
        this.didComplete = false;
        this.completions.clear();
        this.completions.addAll(words);
        this.index = 0;
        if (!this.completions.isEmpty()) {
            this.didComplete = true;
            this.complete();
        }
    }

    public void resetDidComplete() {
        this.didComplete = false;
        this.completions.clear();
    }
}

