/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiLabelListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.framework.elements.utils.ITextColoring;
import mchorse.mclib.client.gui.mclib.GuiAbstractDashboard;
import mchorse.mclib.client.gui.mclib.GuiDashboardPanel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.Label;
import mchorse.mclib.client.gui.utils.ScrollDirection;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.Config;
import mchorse.mclib.config.values.IConfigGuiProvider;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.network.mclib.Dispatcher;
import mchorse.mclib.network.mclib.common.PacketRequestConfigs;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.OpHelper;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiConfigPanel
extends GuiDashboardPanel<GuiAbstractDashboard> {
    public GuiIconElement request;
    public GuiIconElement reload;
    public GuiLabelListElement<String> mods;
    public GuiScrollElement options;
    private Config config;
    private IKey title = IKey.lang("mclib.gui.config.title");
    private Map<String, Config> serverConfigs;

    public GuiConfigPanel(Minecraft mc, GuiAbstractDashboard dashboard) {
        super(mc, dashboard);
        this.request = new GuiIconElement(mc, Icons.DOWNLOAD, button -> this.request());
        this.request.tooltip(IKey.lang("mclib.gui.config.request_tooltip"), Direction.BOTTOM);
        this.reload = new GuiIconElement(mc, Icons.REFRESH, button -> this.reload());
        this.reload.tooltip(IKey.lang("mclib.gui.config.reload_tooltip"), Direction.BOTTOM);
        this.mods = new GuiLabelListElement(mc, mod -> this.selectConfig((String)((Label)mod.get((int)0)).value));
        this.options = new GuiScrollElement(mc, ScrollDirection.HORIZONTAL);
        this.options.scroll.scrollSpeed = 51;
        this.reload.flex().relative(this).set(106.0f, 12.0f, 16.0f, 16.0f);
        this.request.flex().relative(this.reload.resizer()).set(-20.0f, 0.0f, 16.0f, 16.0f);
        this.mods.flex().relative(this).set(10.0f, 35.0f, 110.0f, 0.0f).h(1.0f, -45);
        this.options.flex().relative(this).set(130.0f, 0.0f, 0.0f, 0.0f).w(1.0f, -130).h(1.0f);
        this.options.flex().column(5).scroll().width(240).height(20).padding(15);
        this.fillClientMods();
        this.add(this.reload, this.request, this.mods, this.options);
        this.selectConfig("mclib");
        this.markContainer();
    }

    private void fillClientMods() {
        for (Config config : McLib.proxy.configs.modules.values()) {
            if (config.isServerSide()) continue;
            this.mods.add(IKey.lang(config.getTitleKey()), config.id);
        }
        this.mods.sort();
    }

    @Override
    public void open() {
        this.request.setVisible(!Minecraft.func_71410_x().func_71387_A() && OpHelper.isPlayerOp());
    }

    @Override
    public void close() {
        if (this.serverConfigs != null) {
            this.request();
        }
    }

    @Override
    public boolean canBeOpened(int opLevel) {
        return true;
    }

    public void storeServerConfig(Config config) {
        this.serverConfigs.put(config.id, config);
        this.mods.add(IKey.lang(config.getTitleKey()), config.id);
        this.mods.sort();
        if (config.id.equals("mclib")) {
            this.selectConfig("mclib");
        }
    }

    private void request() {
        this.config = null;
        this.mods.clear();
        if (this.serverConfigs == null) {
            this.serverConfigs = new HashMap<String, Config>();
            this.mods.setCurrent((String)((Object)((Label)null)));
            Dispatcher.sendToServer(new PacketRequestConfigs());
        } else {
            this.serverConfigs = null;
            this.fillClientMods();
            this.selectConfig("mclib");
        }
        this.reload.setEnabled(this.serverConfigs == null);
        this.request.both(this.serverConfigs == null ? Icons.DOWNLOAD : Icons.UPLOAD);
    }

    private void reload() {
        if (this.serverConfigs == null) {
            McLib.proxy.configs.reload();
            this.refresh();
        }
    }

    private void selectConfig(String mod) {
        this.mods.setCurrentValue(mod);
        this.config = this.serverConfigs == null ? McLib.proxy.configs.modules.get(mod) : this.serverConfigs.get(mod);
        this.refresh();
    }

    public void refresh() {
        if (this.config == null) {
            return;
        }
        this.options.removeAll();
        boolean first = true;
        boolean checkForClient = this.serverConfigs != null;
        boolean isSingleplayer = Minecraft.func_71410_x().func_71387_A();
        for (Value category : this.config.values.values()) {
            if (!category.isVisible() || checkForClient && category.isClientSide()) continue;
            String catTitleKey = this.config.getCategoryTitleKey(category);
            String catTooltipKey = this.config.getCategoryTooltipKey(category);
            GuiLabel label = Elements.label(IKey.lang(catTitleKey)).anchor(0.0f, 1.0f).background();
            if (!first) {
                label.margin.top(24);
            }
            label.tooltip(IKey.lang(catTooltipKey), Direction.BOTTOM).flex().w(this.font.func_78256_a(label.label.get()));
            this.options.add((IGuiElement)label);
            for (Value value : category.getSubValues()) {
                if (!value.isVisible() || checkForClient && value.isClientSide() || !(value instanceof IConfigGuiProvider)) continue;
                for (GuiElement element : ((IConfigGuiProvider)((Object)value)).getFields(this.mc, this)) {
                    this.options.add((IGuiElement)element);
                    if (isSingleplayer || checkForClient || value.isClientSide()) continue;
                    for (ITextColoring elem : element.getChildren(ITextColoring.class, new ArrayList(), true)) {
                        elem.setColor(0x999999, true);
                    }
                }
            }
            first = false;
        }
        this.resize();
    }

    @Override
    public void draw(GuiContext context) {
        this.mods.area.draw(-587202560, -10, -35, -10, -10);
        this.font.func_175063_a(this.title.get(), (float)(this.area.x + 10), (float)(this.area.y + 20 - this.font.field_78288_b / 2), 0xFFFFFF);
        super.draw(context);
    }
}

