/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.values;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.config.gui.GuiConfigPanel;
import mchorse.mclib.config.values.IConfigGuiProvider;
import mchorse.mclib.config.values.IServerValue;
import mchorse.mclib.config.values.Value;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ValueBoolean
extends Value
implements IServerValue,
IConfigGuiProvider {
    private boolean value;
    private boolean defaultValue;
    private Boolean serverValue;

    public ValueBoolean(String id) {
        super(id);
    }

    public ValueBoolean(String id, boolean defaultValue) {
        super(id);
        this.defaultValue = defaultValue;
        this.reset();
    }

    public boolean get() {
        return this.serverValue == null ? this.value : this.serverValue;
    }

    public void set(boolean value) {
        this.value = value;
        this.saveLater();
    }

    @Override
    public Object getValue() {
        return this.get();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Boolean) {
            this.set((Boolean)value);
        }
    }

    @Override
    public void reset() {
        this.set(this.defaultValue);
    }

    @Override
    public void resetServer() {
        this.serverValue = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiElement> getFields(Minecraft mc, GuiConfigPanel gui) {
        GuiToggleElement toggle = new GuiToggleElement(mc, this);
        toggle.flex().reset();
        return Arrays.asList(toggle);
    }

    @Override
    public void valueFromJSON(JsonElement element) {
        this.set(element.getAsBoolean());
    }

    @Override
    public JsonElement valueToJSON() {
        return new JsonPrimitive(Boolean.valueOf(this.value));
    }

    @Override
    public boolean parseFromCommand(String value) {
        if (value.equals("1")) {
            this.set(true);
        } else if (value.equals("0")) {
            this.set(false);
        } else {
            this.set(Boolean.parseBoolean(value));
        }
        return true;
    }

    @Override
    public void copy(Value value) {
        super.copy(value);
        if (value instanceof ValueBoolean) {
            this.value = ((ValueBoolean)value).value;
        }
    }

    @Override
    public void copyServer(Value value) {
        super.copyServer(value);
        if (value instanceof ValueBoolean) {
            this.serverValue = ((ValueBoolean)value).value;
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.value = buffer.readBoolean();
        this.defaultValue = buffer.readBoolean();
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeBoolean(this.value);
        buffer.writeBoolean(this.defaultValue);
    }

    public String toString() {
        return Boolean.toString(this.value);
    }
}

