/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.values;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.gui.GuiConfigPanel;
import mchorse.mclib.config.values.IConfigGuiProvider;
import mchorse.mclib.config.values.IServerValue;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ValueFloat
extends Value
implements IServerValue,
IConfigGuiProvider {
    private float value;
    private float defaultValue;
    private float min = Float.NEGATIVE_INFINITY;
    private float max = Float.POSITIVE_INFINITY;
    private Float serverValue;

    public ValueFloat(String id) {
        super(id);
    }

    public ValueFloat(String id, float defaultValue) {
        super(id);
        this.defaultValue = defaultValue;
        this.reset();
    }

    public ValueFloat(String id, float defaultValue, float min, float max) {
        super(id);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.reset();
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public float get() {
        return this.serverValue == null ? this.value : this.serverValue.floatValue();
    }

    public void set(float value) {
        this.value = MathUtils.clamp(value, this.min, this.max);
        this.saveLater();
    }

    @Override
    public Object getValue() {
        return Float.valueOf(this.get());
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Float) {
            this.set(((Float)value).floatValue());
        }
    }

    @Override
    public void reset() {
        this.set(this.defaultValue);
    }

    @Override
    public void resetServer() {
        this.serverValue = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiElement> getFields(Minecraft mc, GuiConfigPanel gui) {
        GuiElement element = new GuiElement(mc);
        GuiLabel label = Elements.label(IKey.lang(this.getLabelKey()), 0).anchor(0.0f, 0.5f);
        GuiTrackpadElement trackpad = new GuiTrackpadElement(mc, this);
        trackpad.flex().w(90);
        element.flex().row(0).preferred(0).height(20);
        element.add(label, trackpad.removeTooltip());
        return Arrays.asList(element.tooltip(IKey.lang(this.getCommentKey())));
    }

    @Override
    public void valueFromJSON(JsonElement element) {
        this.set(element.getAsFloat());
    }

    @Override
    public JsonElement valueToJSON() {
        return new JsonPrimitive((Number)Float.valueOf(this.value));
    }

    @Override
    public boolean parseFromCommand(String value) {
        try {
            this.set(Float.parseFloat(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void copy(Value value) {
        if (value instanceof ValueFloat) {
            this.value = ((ValueFloat)value).value;
        }
    }

    @Override
    public void copyServer(Value value) {
        if (value instanceof ValueFloat) {
            this.serverValue = Float.valueOf(((ValueFloat)value).value);
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.value = buffer.readFloat();
        this.defaultValue = buffer.readFloat();
        this.min = buffer.readFloat();
        this.max = buffer.readFloat();
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeFloat(this.value);
        buffer.writeFloat(this.defaultValue);
        buffer.writeFloat(this.min);
        buffer.writeFloat(this.max);
    }

    public String toString() {
        return Float.toString(this.value);
    }
}

