/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster;

import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.commands.CommandAction;
import mchorse.blockbuster.commands.CommandDamage;
import mchorse.blockbuster.commands.CommandModelBlock;
import mchorse.blockbuster.commands.CommandMount;
import mchorse.blockbuster.commands.CommandOnHead;
import mchorse.blockbuster.commands.CommandRecord;
import mchorse.blockbuster.commands.CommandScene;
import mchorse.blockbuster.commands.CommandSpectate;
import mchorse.blockbuster.utils.mclib.ValueAudioButtons;
import mchorse.blockbuster.utils.mclib.ValueMainButtons;
import mchorse.blockbuster_pack.morphs.StructureMorph;
import mchorse.mclib.McLib;
import mchorse.mclib.commands.utils.L10n;
import mchorse.mclib.config.ConfigBuilder;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.config.values.ValueString;
import mchorse.mclib.events.RegisterConfigEvent;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

@Mod(modid="blockbuster", name="Blockbuster", version="2.3.3", dependencies="after:aperture@[1.7,);before:emoticons@[1.0,);required-after:metamorph@[1.2.11,);required-after:mclib@[2.3.6,);required-after:forge@[14.23.2.2638,)", updateJSON="https://raw.githubusercontent.com/mchorse/blockbuster/1.12/version.json", acceptedMinecraftVersions="[1.12.2]")
public class Blockbuster {
    public static final String MOD_ID = "blockbuster";
    public static final String MODNAME = "Blockbuster";
    public static final String VERSION = "2.3.3";
    public static final String CLIENT_PROXY = "mchorse.blockbuster.ClientProxy";
    public static final String SERVER_PROXY = "mchorse.blockbuster.CommonProxy";
    public static CreativeTabs blockbusterTab;
    public static Item playbackItem;
    public static Item registerItem;
    public static Item actorConfigItem;
    public static Item modelBlockItem;
    public static Item gunItem;
    public static Block directorBlock;
    public static Block modelBlock;
    public static Block greenBlock;
    public static Block dimGreenBlock;
    @Mod.Instance
    public static Blockbuster instance;
    @SidedProxy(clientSide="mchorse.blockbuster.ClientProxy", serverSide="mchorse.blockbuster.CommonProxy")
    public static CommonProxy proxy;
    public static Logger LOGGER;
    public static L10n l10n;
    public static ValueBoolean generalFirstTime;
    public static ValueBoolean debugPlaybackTicks;
    public static ValueBoolean chromaSky;
    public static ValueInt chromaSkyColor;
    public static ValueBoolean syncedURLTextureDownload;
    public static ValueBoolean addUtilityBlocks;
    public static ValueFloat bbGunSyncDistance;
    public static ValueBoolean modelBlockDisableRendering;
    public static ValueBoolean modelBlockDisableItemRendering;
    public static ValueBoolean modelBlockRestore;
    public static ValueBoolean modelBlockResetOnPlayback;
    public static ValueFloat recordingCountdown;
    public static ValueInt recordUnloadTime;
    public static ValueBoolean recordUnload;
    public static ValueInt recordSyncRate;
    public static ValueBoolean recordAttackOnSwipe;
    public static ValueBoolean recordCommands;
    public static ValueString recordChatPrefix;
    public static ValueBoolean recordPausePreview;
    public static ValueBoolean sceneSaveUpdate;
    public static ValueBoolean actorFallDamage;
    public static ValueInt actorTrackingRange;
    public static ValueInt actorRenderingRange;
    public static ValueBoolean actorAlwaysRender;
    public static ValueBoolean actorAlwaysRenderNames;
    public static ValueBoolean actorSwishSwipe;
    public static ValueBoolean actorFixY;
    public static ValueBoolean actorDisableRiding;
    public static ValueBoolean actorPlaybackBodyYaw;
    public static ValueBoolean damageControl;
    public static ValueInt damageControlDistance;
    public static ValueString modelFolderPath;
    public static ValueBoolean snowstormDepthSorting;
    public static ValueBoolean audioWaveformVisible;
    public static ValueInt audioWaveformDensity;
    public static ValueFloat audioWaveformWidth;
    public static ValueInt audioWaveformHeight;
    public static ValueBoolean audioWaveformFilename;
    public static ValueBoolean audioWaveformTime;

    @SideOnly(value=Side.CLIENT)
    public static String WIKI_URL() {
        return Blockbuster.langOrDefault("blockbuster.gui.links.wiki", "https://github.com/mchorse/blockbuster/wiki");
    }

    @SideOnly(value=Side.CLIENT)
    public static String DISCORD_URL() {
        return Blockbuster.langOrDefault("blockbuster.gui.links.discord", "https://discord.gg/qfxrqUF");
    }

    @SideOnly(value=Side.CLIENT)
    public static String CHANNEL_URL() {
        return Blockbuster.langOrDefault("blockbuster.gui.links.channel", "https://www.youtube.com/c/McHorsesMods");
    }

    @SideOnly(value=Side.CLIENT)
    public static String TWITTER_URL() {
        return Blockbuster.langOrDefault("blockbuster.gui.links.twitter", "https://twitter.com/McHorsy");
    }

    @SideOnly(value=Side.CLIENT)
    public static String TUTORIAL_URL() {
        return Blockbuster.langOrDefault("blockbuster.gui.links.tutorial", "https://www.youtube.com/watch?v=qDPEjf2TxAc&list=PLLnllO8nnzE-xmqdymsLpxnXTaAbyIVjM&index=2");
    }

    @SideOnly(value=Side.CLIENT)
    public static String langOrDefault(String lang, String orDefault) {
        String result = I18n.func_135052_a((String)lang, (Object[])new Object[0]);
        return result.equals(lang) ? orDefault : result;
    }

    public static String path(String path) {
        return "blockbuster:" + path;
    }

    public static void reloadServerModels(boolean force) {
        proxy.loadModels(force);
    }

    @SubscribeEvent
    public void onConfigRegister(RegisterConfigEvent event) {
        ConfigBuilder builder = event.createBuilder(MOD_ID);
        builder.category("general").register(new ValueMainButtons("buttons").clientSide());
        generalFirstTime = builder.getBoolean("show_first_time_modal", true);
        generalFirstTime.clientSide();
        debugPlaybackTicks = builder.getBoolean("debug_playback_ticks", false);
        chromaSky = builder.getBoolean("green_screen_sky", false);
        chromaSky.clientSide();
        chromaSkyColor = builder.getInt("green_screen_sky_color", -16711936).colorAlpha();
        chromaSkyColor.clientSide();
        syncedURLTextureDownload = builder.getBoolean("url_skins_sync_download", true);
        syncedURLTextureDownload.clientSide();
        addUtilityBlocks = builder.getBoolean("add_utility_blocks", false);
        addUtilityBlocks.clientSide();
        bbGunSyncDistance = builder.getFloat("bb_gun_sync_distance", 0.0f, 0.0f, 100.0f);
        bbGunSyncDistance.clientSide();
        modelBlockDisableRendering = builder.category("model_block").getBoolean("model_block_disable_rendering", false);
        modelBlockDisableItemRendering = builder.getBoolean("model_block_disable_item_rendering", false);
        modelBlockRestore = builder.getBoolean("restore", false);
        builder.getCategory().markClientSide();
        modelBlockResetOnPlayback = builder.getBoolean("reset_on_playback", false);
        recordingCountdown = builder.category("recording").getFloat("recording_countdown", 1.5f, 0.0f, 10.0f);
        recordUnloadTime = builder.getInt("record_unload_time", 2400, 600, 72000);
        recordUnload = builder.getBoolean("record_unload", true);
        recordSyncRate = builder.getInt("record_sync_rate", 6, 1, 30);
        recordAttackOnSwipe = builder.getBoolean("record_attack_on_swipe", true);
        recordCommands = builder.getBoolean("record_commands", true);
        recordChatPrefix = builder.getString("record_chat_prefix", "");
        recordPausePreview = builder.getBoolean("record_pause_preview", true);
        sceneSaveUpdate = builder.category("scenes").getBoolean("save_update", true);
        actorFallDamage = builder.category("actor").getBoolean("actor_fall_damage", true);
        actorTrackingRange = builder.getInt("actor_tracking_range", 256, 64, 1024);
        actorRenderingRange = builder.getInt("actor_rendering_range", 256, 64, 1024);
        actorRenderingRange.clientSide();
        actorAlwaysRender = builder.getBoolean("actor_always_render", false);
        actorAlwaysRender.clientSide();
        actorAlwaysRenderNames = builder.getBoolean("actor_always_render_names", false);
        actorAlwaysRenderNames.clientSide();
        actorSwishSwipe = builder.getBoolean("actor_swish_swipe", false);
        actorFixY = builder.getBoolean("actor_y", false);
        actorFixY.clientSide();
        actorDisableRiding = builder.getBoolean("actor_disable_riding", false);
        actorPlaybackBodyYaw = builder.getBoolean("actor_playback_body_yaw", true);
        actorPlaybackBodyYaw.clientSide();
        damageControl = builder.category("damage_control").getBoolean("damage_control", true);
        damageControlDistance = builder.getInt("damage_control_distance", 64, 1, 1024);
        modelFolderPath = builder.category("model_folders").getString("path", "");
        snowstormDepthSorting = builder.category("snowstorm").getBoolean("depth_sorting", false);
        builder.getCategory().markClientSide();
        builder.category("audio").register((Value)new ValueAudioButtons("buttons"));
        audioWaveformVisible = builder.getBoolean("waveform_visible", true);
        audioWaveformDensity = builder.getInt("waveform_density", 20, 10, 100);
        audioWaveformWidth = builder.getFloat("waveform_width", 0.5f, 0.0f, 1.0f);
        audioWaveformHeight = builder.getInt("waveform_height", 24, 10, 40);
        audioWaveformFilename = builder.getBoolean("waveform_filename", true);
        audioWaveformTime = builder.getBoolean("waveform_time", true);
        builder.getCategory().markClientSide();
    }

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        McLib.EVENT_BUS.register((Object)this);
        proxy.preLoad(event);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.load(event);
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent event) {
        proxy.postLoad(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        StructureMorph.STRUCTURE_CACHE.clear();
        proxy.loadModels(false);
        event.registerServerCommand((ICommand)new CommandAction());
        event.registerServerCommand((ICommand)new CommandDamage());
        event.registerServerCommand((ICommand)new CommandRecord());
        event.registerServerCommand((ICommand)new CommandOnHead());
        event.registerServerCommand((ICommand)new CommandSpectate());
        event.registerServerCommand((ICommand)new CommandScene());
        event.registerServerCommand((ICommand)new CommandModelBlock());
        event.registerServerCommand((ICommand)new CommandMount());
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        CommonProxy.manager.reset();
        CommonProxy.damage.reset();
        CommonProxy.scenes.reset();
    }

    static {
        l10n = new L10n(MOD_ID);
    }
}

