/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api;

import com.google.common.base.MoreObjects;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import mchorse.blockbuster.api.ModelLimb;
import mchorse.blockbuster.api.ModelPose;
import mchorse.blockbuster.api.ModelTransform;
import mchorse.blockbuster.api.formats.obj.OBJMaterial;
import mchorse.blockbuster.api.json.ModelAdapter;
import mchorse.blockbuster.api.json.ModelLimbAdapter;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class Model {
    public static final List<String> REQUIRED_POSES = Arrays.asList("standing");
    @Expose
    public String scheme = "1.3";
    @Expose
    public String name = "";
    @Expose
    public ResourceLocation defaultTexture;
    @Expose
    public int[] texture = new int[]{64, 32};
    @Expose
    public int extrudeMaxFactor = 1;
    @Expose
    public int extrudeInwards = 1;
    @Expose
    public float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    @Expose
    public float scaleGui = 1.0f;
    @Expose
    public String model = "";
    @Expose
    public boolean providesObj = false;
    @Expose
    public boolean providesMtl = false;
    @Expose
    public boolean legacyObj = true;
    @Expose
    public String skins = "";
    @Expose
    public Map<String, ModelLimb> limbs = new HashMap<String, ModelLimb>();
    @Expose
    public Map<String, ModelPose> poses = new HashMap<String, ModelPose>();
    @Expose
    public Map<String, String> presets = new HashMap<String, String>();
    public Map<String, OBJMaterial> materials = new HashMap<String, OBJMaterial>();
    public List<String> shapes = new ArrayList<String>();

    public static Model parse(InputStream stream) throws Exception {
        Scanner scanner = new Scanner(stream, "UTF-8");
        Model model = Model.parse(scanner.useDelimiter("\\A").next());
        scanner.close();
        return model;
    }

    public static Model parse(String json) throws Exception {
        Gson gson = new GsonBuilder().registerTypeAdapter(Model.class, (Object)new ModelAdapter()).registerTypeAdapter(ModelLimb.class, (Object)new ModelLimbAdapter()).excludeFieldsWithoutExposeAnnotation().create();
        Model data = (Model)gson.fromJson(json, Model.class);
        for (String key : REQUIRED_POSES) {
            if (data.poses.containsKey(key)) continue;
            throw new Exception(I18n.func_135052_a((String)"blockbuster.parsing.lacks_pose", (Object[])new Object[]{data.name, key}));
        }
        if (data.limbs.isEmpty()) {
            throw new Exception(I18n.func_135052_a((String)"blockbuster.parsing.lacks_limbs", (Object[])new Object[]{data.name}));
        }
        data.fillInMissing();
        return data;
    }

    public boolean hasTexturedMaterials() {
        if (this.materials.isEmpty()) {
            return false;
        }
        for (OBJMaterial material : this.materials.values()) {
            if (!material.useTexture) continue;
            return true;
        }
        return false;
    }

    public ModelLimb addLimb(String name) {
        return this.addLimb(new ModelLimb(name));
    }

    public ModelLimb addLimb(ModelLimb limb) {
        this.limbs.put(limb.name, limb);
        for (ModelPose pose : this.poses.values()) {
            pose.limbs.put(limb.name, new ModelTransform());
        }
        return limb;
    }

    public void removeLimb(ModelLimb limb) {
        this.limbs.remove(limb.name);
        ArrayList<ModelLimb> limbsToRemove = new ArrayList<ModelLimb>();
        for (ModelLimb child : this.limbs.values()) {
            if (!child.parent.equals(limb.name)) continue;
            limbsToRemove.add(child);
        }
        for (ModelPose pose : this.poses.values()) {
            pose.limbs.remove(limb.name);
        }
        for (ModelLimb limbToRemove : limbsToRemove) {
            this.removeLimb(limbToRemove);
        }
    }

    public boolean renameLimb(ModelLimb limb, String newName) {
        if (this.limbs.containsKey(newName) || !this.limbs.containsValue(limb)) {
            return false;
        }
        for (ModelPose pose : this.poses.values()) {
            ModelTransform transform = pose.limbs.remove(limb.name);
            pose.limbs.put(newName, transform);
        }
        for (ModelLimb child : this.limbs.values()) {
            if (!child.parent.equals(limb.name)) continue;
            child.parent = newName;
        }
        this.limbs.remove(limb.name);
        this.limbs.put(newName, limb);
        limb.name = newName;
        return true;
    }

    public int getLimbCount(ModelLimb parent) {
        int count = 1;
        for (ModelLimb child : this.limbs.values()) {
            if (!child.parent.equals(parent.name)) continue;
            count += this.getLimbCount(child);
        }
        return count;
    }

    public void fillInMissing() {
        for (Map.Entry<String, ModelLimb> entry : this.limbs.entrySet()) {
            String key = entry.getKey();
            for (ModelPose pose : this.poses.values()) {
                if (pose.limbs.containsKey(key)) continue;
                pose.limbs.put(key, new ModelTransform());
            }
            entry.getValue().name = key;
        }
    }

    public ModelPose getPose(String key) {
        ModelPose pose = this.poses.get(key);
        return pose == null ? this.poses.get("standing") : pose;
    }

    public Model copy() {
        Model b = new Model();
        b.texture = new int[]{this.texture[0], this.texture[1]};
        b.scale = new float[]{this.scale[0], this.scale[1], this.scale[2]};
        b.scaleGui = this.scaleGui;
        b.name = this.name;
        b.scheme = this.scheme;
        b.model = this.model;
        b.defaultTexture = this.defaultTexture == null ? null : RLUtils.clone((ResourceLocation)this.defaultTexture);
        b.providesObj = this.providesObj;
        b.providesMtl = this.providesMtl;
        b.legacyObj = this.legacyObj;
        b.skins = this.skins;
        for (Map.Entry<String, ModelLimb> entry : this.limbs.entrySet()) {
            b.limbs.put(entry.getKey(), entry.getValue().clone());
        }
        for (Map.Entry<String, Object> entry : this.poses.entrySet()) {
            b.poses.put(entry.getKey(), ((ModelPose)entry.getValue()).copy());
        }
        b.presets.putAll(this.presets);
        b.shapes.addAll(this.shapes);
        return b;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("scheme", (Object)this.scheme).add("name", (Object)this.name).add("texture", (Object)Arrays.toString(this.texture)).add("limbs", this.limbs).add("poses", this.poses).toString();
    }
}

