/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api;

import com.google.common.base.MoreObjects;
import mchorse.mclib.utils.Interpolation;
import mchorse.mclib.utils.NBTUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ModelTransform {
    public static final ModelTransform DEFAULT = new ModelTransform();
    public float[] translate = new float[]{0.0f, 0.0f, 0.0f};
    public float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    public float[] rotate = new float[]{0.0f, 0.0f, 0.0f};

    public static boolean equalFloatArray(float[] a, float[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!(Math.abs(a[i] - b[i]) > 1.0E-4f)) continue;
            return false;
        }
        return true;
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    public void copy(ModelTransform transform) {
        int i;
        for (i = 0; i < 3; ++i) {
            this.translate[i] = transform.translate[i];
        }
        for (i = 0; i < 3; ++i) {
            this.scale[i] = transform.scale[i];
        }
        for (i = 0; i < 3; ++i) {
            this.rotate[i] = transform.rotate[i];
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelTransform) {
            ModelTransform transform = (ModelTransform)obj;
            return ModelTransform.equalFloatArray(this.translate, transform.translate) && ModelTransform.equalFloatArray(this.rotate, transform.rotate) && ModelTransform.equalFloatArray(this.scale, transform.scale);
        }
        return super.equals(obj);
    }

    public ModelTransform clone() {
        ModelTransform b = new ModelTransform();
        b.translate = new float[]{this.translate[0], this.translate[1], this.translate[2]};
        b.rotate = new float[]{this.rotate[0], this.rotate[1], this.rotate[2]};
        b.scale = new float[]{this.scale[0], this.scale[1], this.scale[2]};
        return b;
    }

    public void fromNBT(NBTTagCompound tag) {
        if (tag.func_150297_b("P", 9)) {
            NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("P", 5), (float[])this.translate);
        }
        if (tag.func_150297_b("S", 9)) {
            NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("S", 5), (float[])this.scale);
        }
        if (tag.func_150297_b("R", 9)) {
            NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("R", 5), (float[])this.rotate);
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (!this.isDefault()) {
            if (!ModelTransform.equalFloatArray(ModelTransform.DEFAULT.translate, this.translate)) {
                tag.func_74782_a("P", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (float[])this.translate));
            }
            if (!ModelTransform.equalFloatArray(ModelTransform.DEFAULT.scale, this.scale)) {
                tag.func_74782_a("S", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (float[])this.scale));
            }
            if (!ModelTransform.equalFloatArray(ModelTransform.DEFAULT.rotate, this.rotate)) {
                tag.func_74782_a("R", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (float[])this.rotate));
            }
        }
        return tag;
    }

    @SideOnly(value=Side.CLIENT)
    public void transform() {
        this.applyTranslate();
        this.applyRotate();
        this.applyScale();
    }

    @SideOnly(value=Side.CLIENT)
    public void applyTranslate() {
        GL11.glTranslatef((float)this.translate[0], (float)this.translate[1], (float)this.translate[2]);
    }

    @SideOnly(value=Side.CLIENT)
    public void applyRotate() {
        GL11.glRotatef((float)this.rotate[2], (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)this.rotate[1], (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.rotate[0], (float)1.0f, (float)0.0f, (float)0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void applyScale() {
        GL11.glScalef((float)this.scale[0], (float)this.scale[1], (float)this.scale[2]);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("translate", (Object)this.translate).add("scale", (Object)this.scale).add("rotate", (Object)this.rotate).toString();
    }

    public void interpolate(ModelTransform a, ModelTransform b, float x, Interpolation interp) {
        for (int i = 0; i < this.translate.length; ++i) {
            this.translate[i] = interp.interpolate(a.translate[i], b.translate[i], x);
            this.scale[i] = interp.interpolate(a.scale[i], b.scale[i], x);
            this.rotate[i] = interp.interpolate(a.rotate[i], b.rotate[i], x);
        }
    }
}

