/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client;

import com.google.common.collect.ImmutableSet;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.client.textures.GifProcessThread;
import mchorse.blockbuster.client.textures.URLDownloadThread;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ActorsPack
implements IResourcePack {
    private File lastFile;

    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        String domain = location.func_110624_b();
        String path = location.func_110623_a();
        if (path.toLowerCase().endsWith(".gif")) {
            this.handleGif(location);
        }
        if ((domain.equals("http") || domain.equals("https")) && path.startsWith("//") && !path.endsWith(".mcmeta")) {
            return this.hanldeURLSkins(location);
        }
        File fileFile = this.lastFile;
        if (fileFile == null) {
            for (File file : Blockbuster.proxy.pack.folders) {
                File packFile = new File(file, path);
                if (!packFile.exists()) continue;
                fileFile = packFile;
                break;
            }
        }
        if (fileFile != null) {
            this.lastFile = null;
            return new FileInputStream(fileFile);
        }
        throw new FileNotFoundException(location.toString());
    }

    private void handleGif(ResourceLocation location) {
        if (GifProcessThread.THREADS.containsKey(location)) {
            return;
        }
        new Thread(() -> Minecraft.func_71410_x().func_152344_a(() -> GifProcessThread.create(location))).start();
    }

    private InputStream hanldeURLSkins(ResourceLocation location) {
        try {
            if (Blockbuster.syncedURLTextureDownload.get()) {
                InputStream stream = URLDownloadThread.downloadImage(location);
                if (stream == null) {
                    throw new IOException("Couldn't download image...");
                }
                return stream;
            }
            new Thread(new URLDownloadThread(location)).start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ActorsPack.class.getResourceAsStream("/assets/blockbuster/textures/blocks/black.png");
    }

    public boolean func_110589_b(ResourceLocation location) {
        String domain = location.func_110624_b();
        String path = location.func_110623_a();
        if ((domain.equals("http") || domain.equals("https")) && path.startsWith("//") && !path.endsWith(".mcmeta")) {
            return true;
        }
        for (File file : Blockbuster.proxy.pack.folders) {
            this.lastFile = new File(file, path);
            if (!this.lastFile.exists()) continue;
            return true;
        }
        this.lastFile = null;
        return false;
    }

    public Set<String> func_110587_b() {
        return ImmutableSet.of((Object)"b.a", (Object)"http", (Object)"https");
    }

    public String func_130077_b() {
        return "Blockbuster's Actor Pack";
    }

    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }
}

