/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.recording_editor;

import java.util.List;
import java.util.function.Consumer;
import mchorse.blockbuster.client.gui.dashboard.panels.recording_editor.GuiRecordingEditorPanel;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.actions.ActionRegistry;
import mchorse.blockbuster.recording.actions.MorphAction;
import mchorse.blockbuster_pack.morphs.SequencerMorph;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.ScrollArea;
import mchorse.mclib.client.gui.utils.ScrollDirection;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.bodypart.BodyPart;
import mchorse.metamorph.bodypart.BodyPartManager;
import mchorse.metamorph.bodypart.IBodyPartProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.MathHelper;

public class GuiRecordSelector
extends GuiElement {
    public GuiRecordingEditorPanel panel;
    public ScrollArea scroll = new ScrollArea(34);
    public ScrollArea vertical;
    public Consumer<Action> callback;
    public int tick = -1;
    public int index = -1;
    public boolean lastDragging = false;
    public int lastX;
    public int lastY;
    public int lastH;
    public int lastV;
    public boolean dragging;
    public boolean moving;
    public int cursor = -1;
    private int adaptiveMaxIndex;

    public GuiRecordSelector(Minecraft mc, GuiRecordingEditorPanel panel, Consumer<Action> callback) {
        super(mc);
        this.scroll.direction = ScrollDirection.HORIZONTAL;
        this.scroll.scrollSpeed = 68;
        this.vertical = new ScrollArea(20);
        this.panel = panel;
        this.callback = callback;
    }

    public void reset() {
    }

    public void resize() {
        super.resize();
        this.scroll.copy(this.area);
        this.vertical.copy(this.area);
    }

    public void update() {
        if (this.panel.record != null) {
            int count = this.panel.record.actions.size();
            this.tick = MathUtils.clamp((int)this.tick, (int)0, (int)(count - 1));
            this.index = -1;
            this.scroll.setSize(count);
            this.scroll.clamp();
            this.recalculateVertical();
        }
    }

    public void recalculateVertical() {
        int max = 0;
        if (this.panel.record != null) {
            for (List<Action> actions : this.panel.record.actions) {
                if (actions == null || actions.size() <= max) continue;
                max = actions.size();
            }
            ++max;
        }
        this.vertical.setSize(max);
        this.vertical.clamp();
    }

    public boolean mouseClicked(GuiContext context) {
        this.lastX = context.mouseX;
        this.lastY = context.mouseY;
        if (context.mouseButton == 2 && this.area.isInside(context)) {
            this.lastDragging = true;
            this.lastH = this.scroll.scroll;
            this.lastV = this.vertical.scroll;
            return true;
        }
        if (super.mouseClicked(context) || this.scroll.mouseClicked(context) || this.vertical.mouseClicked(context)) {
            return true;
        }
        if (this.scroll.isInside(context) && !this.moving) {
            int index = this.scroll.getIndex(context.mouseX, context.mouseY);
            int sub = this.vertical.getIndex(context.mouseX, context.mouseY);
            if (index >= 0 && index < this.panel.record.actions.size()) {
                boolean within;
                List<Action> actions = this.panel.record.actions.get(index);
                boolean bl = within = actions != null && sub >= 0 && sub < actions.size();
                if (this.callback != null) {
                    this.callback.accept(actions != null && within ? actions.get(sub) : null);
                }
                this.tick = index;
                int n = this.index = within ? sub : -1;
                if (this.index != -1) {
                    this.dragging = true;
                    this.moving = false;
                }
            } else {
                this.tick = -1;
            }
        }
        return false;
    }

    public boolean mouseScrolled(GuiContext context) {
        if (super.mouseScrolled(context)) {
            return true;
        }
        boolean shift = GuiScreen.func_146272_n();
        boolean alt = GuiScreen.func_175283_s();
        if (shift && !alt) {
            return this.vertical.mouseScroll(context);
        }
        if (alt && !shift) {
            int scale = this.scroll.scrollItemSize;
            this.scroll.scrollItemSize = MathUtils.clamp((int)(this.scroll.scrollItemSize + (int)Math.copySign(2.0f, context.mouseWheel)), (int)6, (int)50);
            this.scroll.setSize(this.panel.record.actions.size());
            this.scroll.clamp();
            if (this.scroll.scrollItemSize != scale) {
                int value = this.scroll.scroll + (context.mouseX - this.area.x);
                this.scroll.scroll = (int)(((float)value - (float)(value - this.scroll.scroll) * ((float)scale / (float)this.scroll.scrollItemSize)) * ((float)this.scroll.scrollItemSize / (float)scale));
            }
            return true;
        }
        return this.scroll.mouseScroll(context);
    }

    public void mouseReleased(GuiContext context) {
        super.mouseReleased(context);
        if (this.moving) {
            this.panel.moveTo(this.scroll.getIndex(context.mouseX, context.mouseY));
        }
        this.lastDragging = false;
        this.dragging = false;
        this.moving = false;
        this.scroll.mouseReleased(context);
        this.vertical.mouseReleased(context);
    }

    public void draw(GuiContext context) {
        int x;
        int i;
        int index;
        if (this.panel.record == null) {
            return;
        }
        int mouseX = context.mouseX;
        int mouseY = context.mouseY;
        int count = this.panel.record.actions.size();
        if (this.lastDragging) {
            this.scroll.scroll = this.lastH + (this.lastX - mouseX);
            this.scroll.clamp();
            this.vertical.scroll = this.lastV + (this.lastY - mouseY);
            this.vertical.clamp();
        }
        if (this.dragging && !this.moving && (Math.abs(mouseX - this.lastX) > 2 || Math.abs(mouseY - this.lastY) > 2)) {
            this.moving = true;
        }
        this.scroll.drag(mouseX, mouseY);
        this.vertical.drag(mouseX, mouseY);
        this.scroll.draw(-2013265920);
        Gui.func_73734_a((int)this.area.ex(), (int)this.area.y, (int)(this.area.ex() + 20), (int)this.area.ey(), (int)-14540254);
        Gui.func_73734_a((int)(this.area.x - 20), (int)this.area.y, (int)this.area.x, (int)this.area.ey(), (int)-14540254);
        GuiDraw.drawHorizontalGradientRect((int)(this.area.ex() - 8), (int)this.area.y, (int)this.area.ex(), (int)this.area.ey(), (int)0, (int)-2013265920, (float)0.0f);
        GuiDraw.drawHorizontalGradientRect((int)this.area.x, (int)this.area.y, (int)(this.area.x + 8), (int)this.area.ey(), (int)-2013265920, (int)0, (float)0.0f);
        int max = this.area.x + this.scroll.scrollItemSize * count;
        if (max < this.area.ex()) {
            Gui.func_73734_a((int)max, (int)this.area.y, (int)this.area.ex(), (int)this.area.ey(), (int)-1442840576);
        }
        GuiDraw.scissor((int)this.area.x, (int)this.area.y, (int)this.area.w, (int)this.area.h, (GuiContext)context);
        int w = this.scroll.scrollItemSize;
        int diff = index = this.scroll.scroll / w;
        index = (index -= this.adaptiveMaxIndex) < 0 ? 0 : index;
        this.adaptiveMaxIndex = 0;
        int c = i + this.area.w / w + 2 + (diff -= index);
        for (i = index; i < c; ++i) {
            List<Action> actions;
            x = this.scroll.x - this.scroll.scroll + i * w;
            if (i < count) {
                Gui.func_73734_a((int)x, (int)this.scroll.y, (int)(x + 1), (int)this.scroll.ey(), (int)0x22FFFFFF);
            }
            if (i == this.tick) {
                Gui.func_73734_a((int)x, (int)this.scroll.y, (int)(x + w + 1), (int)this.scroll.ey(), (int)1140885759);
            }
            if (i < 0 || i >= count || (actions = this.panel.record.actions.get(i)) == null) continue;
            int j = 0;
            for (Action action : actions) {
                int offset;
                String label = String.valueOf(j);
                int y = this.scroll.y + j * 20 - this.vertical.scroll;
                int color = MathHelper.func_181758_c((float)((float)(ActionRegistry.getType(action) - 1) / 20.0f), (float)1.0f, (float)1.0f);
                boolean selected = i == this.tick && j == this.index;
                int n = offset = this.scroll.scrollItemSize < 18 ? (this.scroll.scrollItemSize - this.font.func_78256_a(label)) / 2 : 6;
                if (!this.moving || !selected) {
                    this.drawAnimationLength(action, x, y, color, selected);
                }
                Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + 20), (int)(color + -2013265920));
                this.font.func_175063_a(label, (float)(x + offset), (float)(y + 6), 0xFFFFFF);
                if (selected) {
                    GuiDraw.drawOutline((int)x, (int)y, (int)(x + w), (int)(y + 20), (int)-1);
                }
                ++j;
            }
        }
        c = i + this.area.w / w + 2 + diff;
        for (i = index; i < c; ++i) {
            if (i % 5 != 0 || i >= count || i == this.cursor) continue;
            x = this.scroll.x - this.scroll.scroll + i * w;
            int y = this.scroll.ey() - 12;
            String str = String.valueOf(i);
            this.func_73733_a(x + 1, y - 6, x + w, y + 12, 0, -2013265920);
            this.font.func_175063_a(str, (float)(x + (this.scroll.scrollItemSize - this.font.func_78256_a(str) + 2) / 2), (float)y, 0xFFFFFF);
        }
        this.scroll.drawScrollbar();
        this.vertical.drawScrollbar();
        if (this.cursor >= 0 && this.cursor < this.panel.record.actions.size()) {
            int x2 = this.scroll.x - this.scroll.scroll + this.cursor * w;
            int cursorX = x2 + 2;
            String label = this.cursor + "/" + this.panel.record.actions.size();
            int width = this.font.func_78256_a(label);
            int height = 2 + this.font.field_78288_b;
            int offsetY = this.scroll.ey() - height;
            if (cursorX + width + 4 > this.scroll.ex()) {
                cursorX -= width + 4 + 2;
            }
            Gui.func_73734_a((int)x2, (int)this.scroll.y, (int)(x2 + 2), (int)this.scroll.ey(), (int)-11012822);
            Gui.func_73734_a((int)cursorX, (int)offsetY, (int)(cursorX + width + 4), (int)(offsetY + height), (int)-1437076182);
            this.font.func_175063_a(label, (float)(cursorX + 2), (float)(offsetY + 2), 0xFFFFFF);
        }
        String label = this.panel.record.filename;
        GuiDraw.drawTextBackground((FontRenderer)this.font, (String)label, (int)(this.area.ex() - this.font.func_78256_a(label) - 5), (int)(this.area.ey() - 13), (int)0xFFFFFF, (int)(-1442840576 + McLib.primaryColor.get()));
        GuiDraw.unscissor((GuiContext)context);
        if (this.moving) {
            int x3 = mouseX - w / 2;
            int y = mouseY;
            Action action = this.panel.record.getAction(this.tick, this.index);
            int color = MathHelper.func_181758_c((float)((float)(ActionRegistry.getType(action) - 1) / 20.0f), (float)1.0f, (float)1.0f);
            this.drawAnimationLength(action, x3, y, color, true);
            Gui.func_73734_a((int)x3, (int)y, (int)(x3 + w), (int)(y + 20), (int)(color + -2013265920));
            this.font.func_175063_a(String.valueOf(this.index), (float)(x3 + 6), (float)(y + 6), 0xFFFFFF);
            GuiDraw.drawOutline((int)x3, (int)y, (int)(x3 + w), (int)(y + 20), (int)-1);
        }
        super.draw(context);
        this.cursor = -1;
    }

    private void drawAnimationLength(Action action, int x, int y, int color, boolean selected) {
        if (action instanceof MorphAction) {
            MorphAction morphAction = (MorphAction)action;
            int ticks = this.getLength(morphAction.morph);
            if (ticks > 1) {
                int offset = x + this.scroll.scrollItemSize;
                Gui.func_73734_a((int)offset, (int)(y + 8), (int)(offset + --ticks * this.scroll.scrollItemSize), (int)(y + 12), (int)(selected ? -1 : color + 0x33000000));
                Gui.func_73734_a((int)(offset + ticks * this.scroll.scrollItemSize - 1), (int)y, (int)(offset + ticks * this.scroll.scrollItemSize), (int)(y + 20), (int)(selected ? -1 : -16777216 + color));
            }
            this.adaptiveMaxIndex = Math.max(ticks, this.adaptiveMaxIndex);
        }
    }

    private int getLength(AbstractMorph morph) {
        int ticks = 0;
        if (morph instanceof IAnimationProvider) {
            Animation animation = ((IAnimationProvider)morph).getAnimation();
            if (animation.animates) {
                ticks = animation.duration;
            }
        } else if (morph instanceof SequencerMorph) {
            SequencerMorph sequencerMorph = (SequencerMorph)morph;
            ticks = (int)sequencerMorph.getDuration();
        }
        if (morph instanceof IBodyPartProvider) {
            BodyPartManager manager = ((IBodyPartProvider)morph).getBodyPart();
            for (BodyPart part : manager.parts) {
                if (part.morph.isEmpty() || part.limb == null || part.limb.isEmpty()) continue;
                ticks = Math.max(ticks, this.getLength(part.morph.get()));
            }
        }
        return ticks;
    }
}

