/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.scene;

import java.util.List;
import mchorse.blockbuster.client.gui.dashboard.panels.scene.GuiScenePanel;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.scene.PacketRequestScenes;
import mchorse.blockbuster.network.common.scene.PacketSceneManage;
import mchorse.blockbuster.network.common.scene.PacketSceneRequestCast;
import mchorse.blockbuster.recording.scene.Scene;
import mchorse.blockbuster.recording.scene.SceneLocation;
import mchorse.blockbuster.recording.scene.SceneManager;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.framework.elements.modals.GuiConfirmModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiPromptModal;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;

public class GuiSceneManager
extends GuiElement {
    public GuiScenePanel parent;
    public GuiStringListElement sceneList;
    public GuiIconElement add;
    public GuiIconElement dupe;
    public GuiIconElement rename;
    public GuiIconElement remove;

    public GuiSceneManager(Minecraft mc, GuiScenePanel parent) {
        super(mc);
        this.parent = parent;
        this.sceneList = new GuiStringListElement(mc, scene -> this.switchScene((String)scene.get(0)));
        this.add = new GuiIconElement(mc, Icons.ADD, b -> this.addScene());
        this.add.tooltip(IKey.lang((String)"blockbuster.gui.scenes.add_scene"));
        this.dupe = new GuiIconElement(mc, Icons.DUPE, b -> this.dupeScene());
        this.dupe.tooltip(IKey.lang((String)"blockbuster.gui.scenes.dupe_scene"));
        this.rename = new GuiIconElement(mc, Icons.EDIT, b -> this.renameScene());
        this.rename.tooltip(IKey.lang((String)"blockbuster.gui.scenes.rename_scene"));
        this.remove = new GuiIconElement(mc, Icons.REMOVE, b -> this.removeScene());
        this.remove.tooltip(IKey.lang((String)"blockbuster.gui.scenes.remove_scene"));
        this.sceneList.flex().relative((IResizer)this.area).set(0.0f, 20.0f, 0.0f, 0.0f).w(1.0f, 0).h(1.0f, -20);
        this.add.flex().relative((IResizer)this.area).set(0.0f, 2.0f, 16.0f, 16.0f).x(1.0f, -78);
        this.dupe.flex().relative(this.add.resizer()).set(20.0f, 0.0f, 16.0f, 16.0f);
        this.rename.flex().relative(this.dupe.resizer()).set(20.0f, 0.0f, 16.0f, 16.0f);
        this.remove.flex().relative(this.rename.resizer()).set(20.0f, 0.0f, 16.0f, 16.0f);
        this.add(new IGuiElement[]{this.sceneList, this.add, this.dupe, this.rename, this.remove});
        this.hideTooltip();
    }

    private void switchScene(String scene) {
        this.parent.close();
        Dispatcher.sendToServer(new PacketSceneRequestCast(new SceneLocation(scene)));
    }

    private void addScene() {
        GuiModal.addFullModal((GuiElement)this, () -> new GuiPromptModal(this.mc, IKey.lang((String)"blockbuster.gui.scenes.add_modal"), name -> {
            if (this.sceneList.getList().contains(name) || !SceneManager.isValidFilename(name)) {
                return;
            }
            Scene scene = new Scene();
            scene.setId((String)name);
            this.sceneList.add(name);
            this.sceneList.sort();
            this.sceneList.setCurrent(name);
            this.parent.setScene(new SceneLocation(scene));
        }).filename());
    }

    private void dupeScene() {
        if (!this.parent.getLocation().isScene()) {
            return;
        }
        GuiModal.addFullModal((GuiElement)this, () -> {
            GuiToggleElement dupeRecordings = new GuiToggleElement(this.mc, IKey.lang((String)"blockbuster.gui.scenes.dupe_recordings"), null);
            GuiPromptModal modal = new GuiPromptModal(this.mc, IKey.lang((String)"blockbuster.gui.scenes.dupe_modal"), name -> {
                if (this.sceneList.getList().contains(name) || !SceneManager.isValidFilename(name)) {
                    return;
                }
                Scene scene = new Scene();
                scene.copy(this.parent.getLocation().getScene());
                scene.setId((String)name);
                scene.setupIds();
                scene.renamePrefix(this.parent.getLocation().getScene().getId(), scene.getId(), id -> id + "_copy");
                if (dupeRecordings.isToggled()) {
                    Dispatcher.sendToServer(new PacketSceneManage(this.parent.getLocation().getScene().getId(), (String)name, 3));
                }
                this.sceneList.add(name);
                this.sceneList.sort();
                this.sceneList.setCurrent(name);
                this.parent.setScene(new SceneLocation(scene));
                this.parent.close();
            });
            dupeRecordings.tooltip(IKey.lang((String)"blockbuster.gui.scenes.dupe_recordings_tooltip"));
            dupeRecordings.flex().relative(modal.bar).y(-50).x(10).w(1.0f, -20);
            modal.add((IGuiElement)dupeRecordings);
            return modal.filename().setValue(this.parent.getLocation().getFilename());
        });
    }

    private void renameScene() {
        if (!this.parent.getLocation().isScene()) {
            return;
        }
        GuiModal.addFullModal((GuiElement)this, () -> {
            GuiPromptModal modal = new GuiPromptModal(this.mc, IKey.lang((String)"blockbuster.gui.scenes.rename_modal"), name -> {
                if (this.sceneList.getList().contains(name) || !SceneManager.isValidFilename(name)) {
                    return;
                }
                String old = this.parent.getLocation().getFilename();
                this.sceneList.remove((Object)old);
                this.parent.getLocation().getScene().setId((String)name);
                this.sceneList.add(name);
                this.sceneList.sort();
                this.sceneList.setCurrent(name);
                this.parent.setScene(new SceneLocation(this.parent.getLocation().getScene()));
                Dispatcher.sendToServer(new PacketSceneManage(old, (String)name, 1));
            });
            return modal.filename().setValue(this.parent.getLocation().getFilename());
        });
    }

    private void removeScene() {
        if (!this.parent.getLocation().isScene()) {
            return;
        }
        GuiModal.addFullModal((GuiElement)this, () -> new GuiConfirmModal(this.mc, IKey.lang((String)"blockbuster.gui.scenes.remove_modal"), value -> {
            if (!value.booleanValue()) {
                return;
            }
            String name = this.parent.getLocation().getFilename();
            this.sceneList.remove((Object)name);
            this.sceneList.update();
            this.sceneList.setCurrent((Object)null);
            this.parent.setScene(new SceneLocation());
            Dispatcher.sendToServer(new PacketSceneManage(name, "", 2));
        }));
    }

    public void setScene(Scene scene) {
        this.sceneList.setCurrent((Object)(scene == null ? "" : scene.getId()));
    }

    public void updateSceneList() {
        Dispatcher.sendToServer(new PacketRequestScenes());
    }

    public void add(List<String> scenes) {
        String current = (String)this.sceneList.getCurrentFirst();
        this.sceneList.clear();
        this.sceneList.add(scenes);
        this.sceneList.sort();
        this.sceneList.setCurrent((Object)current);
    }

    public void draw(GuiContext context) {
        this.area.draw(-1442840576);
        Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)this.area.ex(), (int)(this.area.y + 20), (int)-2013265920);
        this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.scenes.title", (Object[])new Object[0]), (float)(this.area.x + 6), (float)(this.area.y + 7), 0xFFFFFF);
        super.draw(context);
    }
}

