/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.scene;

import java.net.URI;
import java.util.List;
import java.util.function.Supplier;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.aperture.CameraHandler;
import mchorse.blockbuster.client.gui.dashboard.GuiBlockbusterPanel;
import mchorse.blockbuster.client.gui.dashboard.panels.scene.GuiReplaySelector;
import mchorse.blockbuster.client.gui.dashboard.panels.scene.GuiSceneManager;
import mchorse.blockbuster.common.item.ItemPlayback;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.PacketPlaybackButton;
import mchorse.blockbuster.network.common.recording.PacketUpdatePlayerData;
import mchorse.blockbuster.network.common.scene.PacketSceneCast;
import mchorse.blockbuster.network.common.scene.PacketScenePause;
import mchorse.blockbuster.network.common.scene.PacketScenePlayback;
import mchorse.blockbuster.network.common.scene.PacketSceneRecord;
import mchorse.blockbuster.network.common.scene.PacketSceneTeleport;
import mchorse.blockbuster.recording.scene.Replay;
import mchorse.blockbuster.recording.scene.Scene;
import mchorse.blockbuster.recording.scene.SceneLocation;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiDelegateElement;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiPopUpModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiPromptModal;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.mclib.GuiDashboard;
import mchorse.mclib.client.gui.mclib.GuiDashboardPanel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.OpHelper;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiNestedEdit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class GuiScenePanel
extends GuiBlockbusterPanel {
    private GuiElement subChildren;
    private GuiDelegateElement<GuiElement> mainView;
    private GuiElement replays;
    private GuiElement replayEditor;
    private GuiElement configOptions;
    private GuiReplaySelector selector;
    public GuiTextElement title;
    public GuiTextElement startCommand;
    public GuiTextElement stopCommand;
    public GuiToggleElement loops;
    public GuiStringListElement audio;
    public GuiTrackpadElement audioShift;
    public GuiIconElement openAudioFolder;
    public GuiTextElement id;
    public GuiTextElement name;
    public GuiTextElement target;
    public GuiToggleElement invincible;
    public GuiToggleElement invisible;
    public GuiToggleElement enabled;
    public GuiToggleElement fake;
    public GuiToggleElement teleportBack;
    public GuiToggleElement renderLast;
    public GuiTrackpadElement health;
    public GuiButtonElement record;
    public GuiButtonElement rename;
    public GuiButtonElement attach;
    public GuiButtonElement camera;
    public GuiButtonElement teleport;
    public GuiLabel recordingId;
    public GuiNestedEdit pickMorph;
    public GuiSceneManager scenes;
    private SceneLocation location = new SceneLocation();
    private Replay replay;
    private IKey noneAudioTrack = IKey.lang((String)"blockbuster.gui.director.none");

    public GuiScenePanel(Minecraft mc, GuiDashboard dashboard) {
        super(mc, dashboard);
        this.selector = new GuiReplaySelector(mc, replay -> this.setReplay((Replay)replay.get(0)));
        this.selector.flex().set(0.0f, 0.0f, 0.0f, 60.0f).relative((GuiElement)this).w(1.0f, -20).y(1.0f, -60);
        GuiElement left = new GuiElement(mc);
        GuiElement right = new GuiElement(mc);
        left.flex().relative((GuiElement)this).w(120).y(20).hTo((IResizer)this.selector.flex()).column(5).width(100).height(20).padding(10);
        right.flex().relative((GuiElement)this).x(1.0f).y(20).w(120).hTo((IResizer)this.selector.flex()).anchorX(1.0f).column(5).flip().width(100).height(20).padding(10);
        this.subChildren = new GuiElement(mc).noCulling();
        this.subChildren.setVisible(false);
        this.replays = new GuiElement(mc).noCulling();
        this.replayEditor = new GuiElement(mc).noCulling();
        this.replayEditor.setVisible(false);
        this.replayEditor.add(new IGuiElement[]{left, right});
        this.configOptions = new GuiElement(mc).noCulling();
        this.mainView = new GuiDelegateElement(mc, this.replays);
        this.mainView.noCulling();
        this.add((IGuiElement)this.subChildren);
        this.subChildren.add(this.mainView);
        this.title = new GuiTextElement(mc, 80, str -> {
            this.location.getScene().title = str;
        });
        this.startCommand = new GuiTextElement(mc, 10000, str -> {
            this.location.getScene().startCommand = str;
        });
        this.stopCommand = new GuiTextElement(mc, 10000, str -> {
            this.location.getScene().stopCommand = str;
        });
        this.loops = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.director.loops"), false, b -> {
            this.location.getScene().loops = b.isToggled();
        });
        this.audio = new GuiStringListElement(mc, value -> {
            this.location.getScene().audio = ((String)value.get(0)).equals(this.noneAudioTrack.get()) ? "" : (String)value.get(0);
        });
        this.audio.background().tooltip(IKey.lang((String)"blockbuster.gui.director.audio_tooltip"), Direction.RIGHT);
        this.audioShift = new GuiTrackpadElement(mc, value -> {
            this.location.getScene().audioShift = value.intValue();
        });
        this.audioShift.limit(0.0).integer().tooltip(IKey.lang((String)"blockbuster.gui.director.audio_shift_tooltip"));
        this.openAudioFolder = new GuiIconElement(mc, Icons.FOLDER, b -> GuiUtils.openWebLink((URI)ClientProxy.audio.folder.toURI()));
        this.openAudioFolder.tooltip(IKey.lang((String)"blockbuster.gui.director.open_audio_folder"));
        this.title.flex().set(120.0f, 50.0f, 0.0f, 20.0f).relative((IResizer)this.area).w(1.0f, -130);
        this.startCommand.flex().set(120.0f, 90.0f, 0.0f, 20.0f).relative((IResizer)this.area).w(1.0f, -130);
        this.stopCommand.flex().set(120.0f, 130.0f, 0.0f, 20.0f).relative((IResizer)this.area).w(1.0f, -130);
        this.audio.flex().relative((GuiElement)this).xy(10, 50).w(100).hTo((IResizer)this.stopCommand.area, 1.0f);
        this.audioShift.flex().relative((GuiElement)this.audio).y(1.0f, 5).w(1.0f);
        this.openAudioFolder.flex().relative((GuiElement)this.audio).x(1.0f, -16).y(-16).wh(16, 16);
        GuiElement row = Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.loops});
        row.flex().relative((GuiElement)this.stopCommand).y(25).w(1.0f);
        this.loops.flex().h(20);
        this.configOptions.add(new IGuiElement[]{this.title, this.startCommand, this.stopCommand, row, this.audio, this.audioShift, this.openAudioFolder});
        this.id = new GuiTextElement(mc, 120, str -> {
            this.replay.id = str;
            this.updateLabel(true);
        }).filename();
        this.name = new GuiTextElement(mc, 80, str -> {
            this.replay.name = str;
        });
        this.name.tooltip(IKey.lang((String)"blockbuster.gui.director.name_tooltip"), Direction.RIGHT);
        this.target = new GuiTextElement(mc, 80, str -> {
            this.replay.target = str;
        });
        this.target.tooltip(IKey.lang((String)"blockbuster.gui.director.target_tooltip"), Direction.LEFT);
        this.invincible = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.director.invincible"), false, b -> {
            this.replay.invincible = b.isToggled();
        });
        this.invisible = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.director.invisible"), false, b -> {
            this.replay.invisible = b.isToggled();
        });
        this.enabled = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.director.enabled"), false, b -> {
            this.replay.enabled = b.isToggled();
        });
        this.fake = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.director.fake_player"), false, b -> {
            this.replay.fake = b.isToggled();
        });
        this.teleportBack = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.director.tp_back"), false, b -> {
            this.replay.teleportBack = b.isToggled();
        });
        this.teleportBack.tooltip(IKey.lang((String)"blockbuster.gui.director.tp_back_tooltip"), Direction.RIGHT);
        this.renderLast = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.director.render_last"), false, b -> {
            this.replay.renderLast = b.isToggled();
        });
        this.renderLast.tooltip(IKey.lang((String)"blockbuster.gui.director.render_last_tooltip"), Direction.RIGHT);
        this.health = new GuiTrackpadElement(mc, value -> {
            this.replay.health = value.floatValue();
        });
        this.health.limit(0.0);
        this.recordingId = Elements.label((IKey)IKey.lang((String)"blockbuster.gui.director.id")).color(0xCCCCCC);
        left.add(new IGuiElement[]{this.recordingId, this.id});
        left.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.director.name")).color(0xCCCCCC), this.name});
        left.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.director.health")).color(0xCCCCCC), this.health, this.invincible, this.invisible, this.enabled, this.fake, this.teleportBack, this.renderLast});
        this.replays.add(new IGuiElement[]{this.selector, this.replayEditor});
        GuiIconElement toggle = new GuiIconElement(mc, Icons.GEAR, b -> this.mainView.setDelegate(this.mainView.delegate == this.configOptions ? this.replays : this.configOptions));
        GuiIconElement toggleScenes = new GuiIconElement(mc, Icons.MORE, b -> this.scenes.toggleVisible());
        toggleScenes.flex().y(4).relative((IResizer)this.area).x(1.0f, -24);
        toggle.tooltip(IKey.lang((String)"blockbuster.gui.director.config"), Direction.LEFT);
        toggle.flex().y(4).relative((IResizer)this.area).x(1.0f, -44);
        this.add((IGuiElement)toggleScenes);
        this.subChildren.add((IGuiElement)toggle);
        GuiIconElement add = new GuiIconElement(mc, Icons.ADD, b -> this.addReplay());
        GuiIconElement dupe = new GuiIconElement(mc, Icons.DUPE, b -> this.dupeReplay());
        GuiIconElement remove = new GuiIconElement(mc, Icons.REMOVE, b -> this.removeReplay());
        add.tooltip(IKey.lang((String)"blockbuster.gui.director.add_replay"), Direction.LEFT);
        dupe.tooltip(IKey.lang((String)"blockbuster.gui.director.dupe_replay"), Direction.LEFT);
        remove.tooltip(IKey.lang((String)"blockbuster.gui.director.remove_replay"), Direction.LEFT);
        add.flex().set(0.0f, 0.0f, 20.0f, 20.0f).relative(this.selector.resizer()).x(1.0f);
        dupe.flex().set(0.0f, 20.0f, 20.0f, 20.0f).relative(this.selector.resizer()).x(1.0f);
        remove.flex().set(0.0f, 40.0f, 20.0f, 20.0f).relative(this.selector.resizer()).x(1.0f);
        this.replays.add(new IGuiElement[]{add, dupe, remove});
        IKey category = IKey.lang((String)"blockbuster.gui.director.keys.category");
        Supplier<Boolean> active = () -> this.replay != null;
        this.pickMorph = new GuiNestedEdit(mc, editing -> ClientProxy.panels.addMorphs((GuiElement)this, (boolean)editing, this.replay.morph));
        this.record = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.record"), b -> this.sendRecordMessage());
        GuiButtonElement edit = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.director.edit_record"), b -> this.openRecordEditor());
        GuiButtonElement update = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.director.update_data"), b -> this.updatePlayerData());
        this.rename = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.director.rename_prefix"), b -> this.renamePrefix());
        this.attach = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.director.attach"), b -> this.attach());
        this.teleport = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.director.tp"), b -> this.teleport());
        this.teleport.keys().register(this.teleport.label, 20, () -> this.teleport.clickItself(GuiBase.getCurrent())).category(category).active(active);
        this.pickMorph.flex().relative((GuiElement)this.selector).x(0.5f).y(-10).w(100).anchor(0.5f, 1.0f);
        update.tooltip(IKey.lang((String)"blockbuster.gui.director.update_data_tooltip"), Direction.LEFT);
        this.rename.tooltip(IKey.lang((String)"blockbuster.gui.director.rename_prefix_tooltip"), Direction.LEFT);
        this.attach.tooltip(IKey.lang((String)"blockbuster.gui.director.attach_tooltip"), Direction.LEFT);
        this.teleport.tooltip(IKey.lang((String)"blockbuster.gui.director.tp_tooltip"), Direction.LEFT);
        right.add(new IGuiElement[]{this.attach, this.record, update, this.rename, edit});
        if (CameraHandler.isApertureLoaded()) {
            this.camera = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.director.camera"), b -> {
                CameraHandler.location = this.location;
                CameraHandler.openCameraEditor();
            });
            this.camera.keys().register(this.camera.label, 46, () -> this.camera.clickItself(GuiBase.getCurrent())).category(category).active(active);
            right.add((IGuiElement)this.camera);
        }
        right.add((IGuiElement)this.teleport);
        right.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.director.target")).color(0xCCCCCC).marginTop(12), this.target});
        this.replayEditor.add((IGuiElement)this.pickMorph);
        this.scenes = new GuiSceneManager(mc, this);
        this.add((IGuiElement)this.scenes);
        this.scenes.flex().relative((GuiElement)toggleScenes).xy(1.0f, 1.0f).w(160).hTo((IResizer)this.selector.flex()).anchorX(1.0f);
        this.scenes.setVisible(false);
        this.keys().register(IKey.lang((String)"blockbuster.gui.director.keys.toggle_list"), 49, () -> toggleScenes.clickItself(GuiBase.getCurrent())).category(category);
        this.keys().register(IKey.lang((String)"blockbuster.gui.director.keys.toggle_options"), 24, () -> toggle.clickItself(GuiBase.getCurrent())).category(category);
    }

    public SceneLocation getLocation() {
        return this.location;
    }

    public Replay getReplay() {
        return this.replay;
    }

    public List<Replay> getReplays() {
        if (this.location.isEmpty()) {
            return null;
        }
        return this.getLocation().getScene().replays;
    }

    public GuiScenePanel openScene(SceneLocation location) {
        this.scenes.setVisible(false);
        return this.setScene(location);
    }

    public GuiScenePanel setScene(SceneLocation location) {
        this.location = location == null ? new SceneLocation() : location;
        this.subChildren.setVisible(!location.isEmpty());
        this.replayEditor.setVisible(!location.isEmpty());
        this.scenes.setScene(location.getScene());
        if (location.isEmpty()) {
            this.setReplay(null);
            return this;
        }
        this.selector.setList(location.getScene().replays);
        if (!this.location.getScene().replays.isEmpty()) {
            int current = this.location.getScene().replays.indexOf(this.replay);
            this.setReplay(this.location.getScene().replays.get(current == -1 ? 0 : current));
        } else {
            this.setReplay(null);
        }
        this.fillData();
        return this;
    }

    public GuiScenePanel set(SceneLocation location) {
        this.location = location;
        this.scenes.setScene(location.getScene());
        return this;
    }

    @Override
    public void appear() {
        super.appear();
        ClientProxy.panels.picker(this::setMorph);
        if (!this.location.isEmpty()) {
            this.setScene(this.location);
        }
    }

    public void open() {
        if (!OpHelper.isPlayerOp()) {
            return;
        }
        ClientProxy.panels.morphs.reload();
        this.setScene(this.location);
        this.scenes.setScene(this.location.getScene());
        this.scenes.updateSceneList();
    }

    public void close() {
        if (!OpHelper.isPlayerOp()) {
            return;
        }
        if (this.location.isScene()) {
            if (ClientProxy.panels.morphs.hasParent()) {
                ClientProxy.panels.morphs.finish();
            }
            Dispatcher.sendToServer(new PacketSceneCast(this.location));
        }
    }

    private void setReplay(Replay replay) {
        if (this.replay != null) {
            this.replay.morph = MorphUtils.copy((AbstractMorph)this.replay.morph);
        }
        this.replay = replay;
        this.replayEditor.setVisible(this.replay != null);
        this.mainView.setDelegate(this.replays);
        this.selector.setCurrent(replay);
        this.fillReplayData();
    }

    private void fillData() {
        this.title.setText(this.location.getScene().title);
        this.startCommand.setText(this.location.getScene().startCommand);
        this.stopCommand.setText(this.location.getScene().stopCommand);
        this.loops.toggled(this.location.getScene().loops);
        this.attach.setEnabled(false);
        this.audio.clear();
        this.audio.add((Object)this.noneAudioTrack.get());
        this.audio.add(ClientProxy.audio.getFileNames());
        this.audio.sort();
        String audio = this.location.getScene().audio;
        this.audio.setCurrentScroll((Object)(audio == null || audio.isEmpty() ? this.noneAudioTrack.get() : audio));
        this.audioShift.setValue((double)this.location.getScene().audioShift);
        if (this.mc != null && this.mc.field_71439_g != null) {
            ItemStack stack = this.mc.field_71439_g.func_184614_ca();
            this.attach.setEnabled(!this.location.isEmpty() && stack.func_77973_b() instanceof ItemPlayback);
        }
    }

    private void fillReplayData() {
        if (this.replay == null) {
            return;
        }
        this.id.setText(this.replay.id);
        this.name.setText(this.replay.name);
        this.target.setText(this.replay.target);
        this.invincible.toggled(this.replay.invincible);
        this.invisible.toggled(this.replay.invisible);
        this.enabled.toggled(this.replay.enabled);
        this.fake.toggled(this.replay.fake);
        this.teleportBack.toggled(this.replay.teleportBack);
        this.renderLast.toggled(this.replay.renderLast);
        this.health.setValue((double)this.replay.health);
        this.pickMorph.setMorph(this.replay.morph);
        this.selector.setCurrent(this.replay);
        this.updateLabel(false);
    }

    private void addReplay() {
        Replay replay = new Replay("");
        if (this.location.isScene()) {
            replay.id = this.location.getScene().getNextBaseSuffix(this.location.getScene().getId());
        }
        this.location.getScene().replays.add(replay);
        this.setReplay(replay);
        this.selector.update();
    }

    private void dupeReplay() {
        if (this.selector.isDeselected()) {
            return;
        }
        Scene scene = this.location.getScene();
        if (scene.dupe(scene.replays.indexOf(this.replay))) {
            this.selector.update();
            this.selector.scroll.scrollTo(this.selector.getIndex() * this.selector.scroll.scrollItemSize);
            this.setReplay(scene.replays.get(scene.replays.size() - 1));
        }
    }

    private void removeReplay() {
        if (this.selector.isDeselected()) {
            return;
        }
        Scene scene = this.location.getScene();
        int index = this.selector.getIndex();
        scene.replays.remove(this.replay);
        int size = scene.replays.size();
        index = MathHelper.func_76125_a((int)index, (int)0, (int)(size - 1));
        this.setReplay(size == 0 ? null : scene.replays.get(index));
        this.selector.update();
    }

    private void setMorph(AbstractMorph morph) {
        if (this.replay != null) {
            this.replay.morph = morph;
        }
        this.pickMorph.setMorph(morph);
    }

    private void updateLabel(boolean gui) {
        boolean error = this.replay != null && this.replay.id.isEmpty();
        this.recordingId.color(error ? 0xFF3355 : 0xCCCCCC);
        if (this.replay != null && !this.replay.id.isEmpty() && gui) {
            boolean isDuplicate = false;
            for (Replay element : this.scenes.parent.getLocation().getScene().replays) {
                if (!element.id.equals(this.replay.id) || this.replay == element) continue;
                isDuplicate = true;
                break;
            }
            if (isDuplicate) {
                GuiModal.addModal((GuiElement)this, () -> {
                    GuiPopUpModal modal = new GuiPopUpModal(this.mc, IKey.lang((String)"blockbuster.gui.director.rename_replay_dupe_modal"));
                    modal.flex().relative(this.parent).wh(220, 50);
                    return modal;
                });
            }
        }
    }

    private void sendRecordMessage() {
        boolean lastMessageIsntCommand;
        EntityPlayerSP player = this.mc.field_71439_g;
        if (this.replay.id.isEmpty()) {
            Blockbuster.l10n.error((ICommandSender)player, "recording.fill_filename", new Object[0]);
            return;
        }
        String command = "/action record " + this.replay.id + " " + this.location.getFilename();
        TextComponentString component = new TextComponentString(I18n.func_135052_a((String)"blockbuster.info.recording.clickhere", (Object[])new Object[0]));
        component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        component.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(command)));
        component.func_150256_b().func_150238_a(TextFormatting.GRAY).func_150228_d(Boolean.valueOf(true));
        Blockbuster.l10n.info((ICommandSender)player, "recording.message", new Object[]{this.replay.id, component});
        List messages = this.mc.field_71456_v.func_146158_b().func_146238_c();
        boolean empty = messages.isEmpty();
        boolean bl = lastMessageIsntCommand = !empty && !((String)messages.get(messages.size() - 1)).equals(command);
        if (lastMessageIsntCommand || empty) {
            messages.add(command);
        }
    }

    private void attach() {
        if (CameraHandler.isApertureLoaded()) {
            CameraHandler.attach(this.location, this.scenes.sceneList.getList());
        } else {
            Dispatcher.sendToServer(new PacketPlaybackButton(this.location, 0, ""));
            this.mc.func_147108_a(null);
        }
    }

    private void openRecordEditor() {
        if (this.replay != null && !this.replay.id.isEmpty()) {
            ((GuiDashboard)this.dashboard).panels.setPanel((GuiDashboardPanel)ClientProxy.panels.recordingEditorPanel);
            ClientProxy.panels.recordingEditorPanel.selectRecord(this.replay.id);
            ClientProxy.panels.recordingEditorPanel.records.setVisible(false);
        }
    }

    private void updatePlayerData() {
        Dispatcher.sendToServer(new PacketUpdatePlayerData(this.replay.id));
    }

    private void teleport() {
        if (this.replay == null) {
            return;
        }
        this.mc.func_147108_a(null);
        Dispatcher.sendToServer(new PacketSceneTeleport(this.replay.id));
    }

    private void renamePrefix() {
        GuiModal.addModal((GuiElement)this.replayEditor, () -> {
            GuiPromptModal modal = new GuiPromptModal(this.mc, IKey.lang((String)"blockbuster.gui.director.rename_prefix_popup"), this::renamePrefix);
            modal.markIgnored().flex().relative((GuiElement)this.rename).y(1.0f).w(1.0f).h(120);
            return modal;
        });
    }

    private void renamePrefix(String newPrefix) {
        this.location.getScene().renamePrefix(newPrefix);
        this.fillReplayData();
    }

    public void draw(GuiContext context) {
        if (this.scenes.isVisible()) {
            int x = this.scenes.area.ex() - 20;
            int y = this.scenes.area.y - 20;
            Gui.func_73734_a((int)x, (int)y, (int)(x + 20), (int)(y + 20), (int)-2013265920);
        }
        if (this.mainView.delegate == this.replays) {
            AbstractMorph morph;
            Gui.func_73734_a((int)this.selector.area.x, (int)this.selector.area.y, (int)(this.selector.area.ex() + 20), (int)this.selector.area.ey(), (int)-2013265920);
            this.func_73733_a(this.selector.area.x, this.selector.area.y - 16, this.selector.area.ex() + 20, this.selector.area.y, 0, -2013265920);
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.scenes.title", (Object[])new Object[0]), (float)(this.area.x + 10), (float)(this.area.y + 10), 0xFFFFFF);
            if (this.replay != null && (morph = this.replay.morph) != null) {
                int x = this.area.mx();
                int y = this.area.y(0.55f);
                GuiDraw.scissor((int)this.area.x, (int)this.area.y, (int)this.area.w, (int)this.area.h, (GuiContext)context);
                morph.renderOnScreen((EntityPlayer)this.mc.field_71439_g, x, y, (float)this.area.h / 3.5f, 1.0f);
                GuiDraw.unscissor((GuiContext)context);
            }
        } else {
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.director.config", (Object[])new Object[0]), (float)(this.area.x + 10), (float)(this.area.y + 10), 0xFFFFFF);
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.director.audio", (Object[])new Object[0]), (float)this.audio.area.x, (float)(this.audio.area.y - 12), 0xCCCCCC);
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.director.start_command", (Object[])new Object[0]), (float)this.startCommand.area.x, (float)(this.startCommand.area.y - 12), 0xCCCCCC);
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.director.stop_command", (Object[])new Object[0]), (float)this.stopCommand.area.x, (float)(this.stopCommand.area.y - 12), 0xCCCCCC);
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.director.display_title", (Object[])new Object[0]), (float)this.title.area.x, (float)(this.title.area.y - 12), 0xCCCCCC);
        }
        if (this.location.isEmpty()) {
            String no = I18n.func_135052_a((String)"blockbuster.gui.director.not_selected", (Object[])new Object[0]);
            this.func_73732_a(this.font, no, this.area.mx(), this.area.my() - 6, 0xFFFFFF);
        }
        super.draw(context);
    }

    public void plause() {
        if (!OpHelper.isPlayerOp()) {
            return;
        }
        if (this.location.isScene()) {
            Dispatcher.sendToServer(new PacketScenePlayback(this.location));
        }
    }

    public void record() {
        if (!OpHelper.isPlayerOp()) {
            return;
        }
        Replay replay = this.replay;
        if (replay != null && !replay.id.isEmpty() && this.location.isScene()) {
            Dispatcher.sendToServer(new PacketSceneRecord(this.location, replay.id));
        }
    }

    public void pause() {
        if (!OpHelper.isPlayerOp()) {
            return;
        }
        if (this.location.isScene()) {
            Dispatcher.sendToServer(new PacketScenePause(this.location));
        }
    }
}

