/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.snowstorm;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.client.gui.dashboard.GuiBlockbusterPanel;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.GuiSnowstormRenderer;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormAppearanceSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormCollisionAppearanceSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormCollisionLightingSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormCollisionSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormExpirationSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormGeneralSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormInitializationSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormLifetimeSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormLightingSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormMotionSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormParticleMorphSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormRateSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormShapeSection;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormSpaceSection;
import mchorse.blockbuster.client.particles.BedrockLibrary;
import mchorse.blockbuster.client.particles.BedrockScheme;
import mchorse.blockbuster.client.particles.emitter.BedrockEmitter;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringSearchListElement;
import mchorse.mclib.client.gui.framework.elements.modals.GuiConfirmModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiPromptModal;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDrawable;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.mclib.GuiDashboard;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.client.Minecraft;

public class GuiSnowstorm
extends GuiBlockbusterPanel {
    public static final String DEFAULT_PARTICLE = "default_snow";
    public GuiSnowstormRenderer renderer;
    public GuiScrollElement editor;
    public GuiIconElement open;
    public GuiIconElement save;
    public GuiElement modal;
    public GuiIconElement add;
    public GuiIconElement dupe;
    public GuiIconElement remove;
    public GuiIconElement folder;
    public GuiStringSearchListElement particles;
    public List<GuiSnowstormSection> sections = new ArrayList<GuiSnowstormSection>();
    private GuiSnowstormParticleMorphSection particleMorphSection;
    private BedrockLibrary library;
    private String filename;
    private BedrockScheme scheme;
    private boolean dirty;

    public GuiSnowstorm(Minecraft mc, GuiDashboard dashboard) {
        super(mc, dashboard);
        this.library = Blockbuster.proxy.particles;
        this.renderer = new GuiSnowstormRenderer(mc);
        this.renderer.flex().relative((GuiElement)this).wh(1.0f, 1.0f);
        this.editor = new GuiScrollElement(mc);
        this.editor.flex().relative((GuiElement)this).x(1.0f).w(200).h(1.0f).anchorX(1.0f).column(20).vertical().stretch().scroll().padding(10);
        this.open = new GuiIconElement(mc, Icons.MORE, b -> this.modal.toggleVisible());
        this.open.tooltip(IKey.lang((String)"blockbuster.gui.snowstorm.open_tooltip"));
        this.open.flex().relative((GuiElement)this);
        this.save = new GuiIconElement(mc, Icons.SAVE, b -> this.save());
        this.save.tooltip(IKey.lang((String)"blockbuster.gui.snowstorm.save_tooltip"));
        this.save.flex().relative((GuiElement)this.open).x(20);
        this.modal = new GuiElement(mc);
        this.modal.flex().relative((GuiElement)this).y(20).w(160).hTo((IResizer)this.area, 1.0f, -16);
        GuiLabel label = Elements.label((IKey)IKey.lang((String)"blockbuster.gui.snowstorm.title"), (int)20).anchor(0.0f, 0.5f);
        label.flex().relative(this.modal).xy(10, 10).w(1.0f, -20);
        this.add = new GuiIconElement(mc, Icons.ADD, b -> this.addEffect());
        this.add.tooltip(IKey.lang((String)"blockbuster.gui.snowstorm.add_tooltip"));
        this.dupe = new GuiIconElement(mc, Icons.DUPE, b -> this.dupeEffect());
        this.dupe.tooltip(IKey.lang((String)"blockbuster.gui.snowstorm.dupe_tooltip"));
        this.remove = new GuiIconElement(mc, Icons.REMOVE, b -> this.removeEffect());
        this.folder = new GuiIconElement(mc, Icons.FOLDER, b -> GuiUtils.openWebLink((URI)this.library.folder.toURI()));
        this.folder.tooltip(IKey.lang((String)"blockbuster.gui.snowstorm.folder_tooltip"));
        this.particles = new GuiStringSearchListElement(mc, list -> this.setScheme((String)list.get(0)));
        this.particles.flex().relative(this.modal).xy(10, 35).w(1.0f, -20).h(1.0f, -45);
        this.particleMorphSection = new GuiSnowstormParticleMorphSection(mc, this);
        GuiElement icons = new GuiElement(mc);
        icons.flex().relative(this.modal).x(1.0f, -10).y(10).h(20).anchorX(1.0f).row(0).resize().width(20).height(20);
        icons.add(new IGuiElement[]{this.add, this.dupe, this.remove, this.folder});
        this.modal.add(new IGuiElement[]{label, icons, this.particles});
        this.modal.setVisible(false);
        this.add(new IGuiElement[]{this.renderer, new GuiDrawable(this::drawOverlay), this.editor, this.modal, this.open, this.save});
        this.addSection(new GuiSnowstormGeneralSection(mc, this));
        this.addSection(new GuiSnowstormSpaceSection(mc, this));
        this.addSection(new GuiSnowstormInitializationSection(mc, this));
        this.addSection(new GuiSnowstormRateSection(mc, this));
        this.addSection(new GuiSnowstormLifetimeSection(mc, this));
        this.addSection(new GuiSnowstormShapeSection(mc, this));
        this.addSection(new GuiSnowstormMotionSection(mc, this));
        this.addSection(new GuiSnowstormExpirationSection(mc, this));
        this.addSection(new GuiSnowstormAppearanceSection(mc, this));
        this.addSection(new GuiSnowstormLightingSection(mc, this));
        this.addSection(new GuiSnowstormCollisionSection(mc, this));
        this.addSection(new GuiSnowstormCollisionAppearanceSection(mc, this));
        this.addSection(new GuiSnowstormCollisionLightingSection(mc, this));
        this.keys().register(IKey.lang((String)"blockbuster.gui.snowstorm.keys.save"), 31, () -> this.save.clickItself(GuiBase.getCurrent())).held(new int[]{29}).category(IKey.lang((String)"blockbuster.gui.snowstorm.keys.category"));
    }

    private void addEffect() {
        GuiModal.addFullModal((GuiElement)this.modal, () -> new GuiPromptModal(this.mc, IKey.lang((String)"blockbuster.gui.snowstorm.add_modal"), name -> {
            if (this.library.hasEffect((String)name) || name.isEmpty()) {
                return;
            }
            BedrockScheme scheme = this.library.load(DEFAULT_PARTICLE);
            scheme.identifier = name;
            this.setScheme((String)name, scheme);
            this.dirty();
            this.particles.list.setCurrent((Object)"");
        }));
    }

    private void dupeEffect() {
        GuiModal.addFullModal((GuiElement)this.modal, () -> new GuiPromptModal(this.mc, IKey.lang((String)"blockbuster.gui.snowstorm.dupe_modal"), name -> {
            if (this.library.hasEffect((String)name) || name.isEmpty()) {
                return;
            }
            if (!this.scheme.isFactory()) {
                this.particles.list.setCurrent((Object)"");
            }
            BedrockScheme scheme = BedrockScheme.dupe(this.scheme);
            scheme.factory(this.library.factory.containsKey(name));
            scheme.identifier = name;
            this.setScheme((String)name, scheme);
            this.save();
        }).setValue(this.filename));
    }

    private void removeEffect() {
        if (this.scheme.isFactory()) {
            return;
        }
        GuiModal.addFullModal((GuiElement)this.modal, () -> new GuiConfirmModal(this.mc, IKey.lang((String)"blockbuster.gui.snowstorm.remove_modal"), confirm -> {
            if (!confirm.booleanValue() || !this.library.hasEffect(this.filename)) {
                return;
            }
            int index = this.particles.list.getIndex();
            if (this.library.file(this.filename).delete()) {
                if (!this.library.factory.containsKey(this.filename)) {
                    this.particles.list.remove((Object)this.filename);
                }
                index = MathUtils.clamp((int)index, (int)0, (int)(this.particles.list.getList().size() - 1));
                this.particles.list.setIndex(index);
                this.setScheme((String)this.particles.list.getCurrentFirst());
            }
        }));
    }

    public void dirty() {
        this.dirty = true;
        this.updateSaveButton();
        this.renderer.emitter.setupVariables();
    }

    private void updateSaveButton() {
        this.save.both(this.dirty ? Icons.SAVE : Icons.SAVED);
    }

    private void updateRemoveButton() {
        this.remove.setEnabled(!this.scheme.isFactory());
        if (this.remove.isEnabled()) {
            this.remove.tooltip(IKey.lang((String)"blockbuster.gui.snowstorm.remove_tooltip"));
        } else {
            this.remove.tooltip(IKey.lang((String)"blockbuster.gui.snowstorm.remove_factory_tooltip"));
        }
    }

    private void save() {
        for (GuiSnowstormSection section : this.sections) {
            section.beforeSave(this.scheme);
        }
        this.library.save(this.filename, this.scheme);
        if (!this.particles.list.getList().contains(this.filename)) {
            this.particles.list.add((Object)this.filename);
            this.particles.list.sort();
            this.particles.list.setCurrent((Object)this.filename);
        }
        this.dirty = false;
        this.scheme.factory(false);
        this.updateSaveButton();
        this.updateRemoveButton();
    }

    private void addSection(GuiSnowstormSection section) {
        this.sections.add(section);
        this.editor.add((IGuiElement)section);
    }

    private void setScheme(String scheme) {
        this.setScheme(scheme, this.library.load(scheme));
    }

    private void setScheme(String name, BedrockScheme scheme) {
        if (scheme == null) {
            this.particles.list.remove((Object)name);
            this.particles.list.setIndex(-1);
            return;
        }
        this.filename = name;
        this.scheme = scheme;
        this.renderer.setScheme(this.scheme);
        this.dirty = false;
        this.updateSaveButton();
        this.updateRemoveButton();
        for (GuiSnowstormSection section : this.sections) {
            section.setScheme(this.scheme);
        }
        this.editor.resize();
    }

    @Override
    public void appear() {
        super.appear();
        String current = (String)this.particles.list.getCurrentFirst();
        this.particles.filter("", true);
        this.particles.list.clear();
        this.particles.list.add(this.library.presets.keySet());
        this.particles.list.sort();
        if (this.scheme == null) {
            this.setScheme(DEFAULT_PARTICLE);
            this.particles.list.setCurrent((Object)DEFAULT_PARTICLE);
        } else {
            this.particles.list.setCurrent((Object)current);
        }
        ClientProxy.panels.picker(this.particleMorphSection::setMorph);
    }

    public void close() {
        if (this.renderer.emitter != null) {
            this.renderer.emitter.particles.clear();
        }
    }

    private void drawOverlay(GuiContext context) {
        BedrockEmitter emitter = this.renderer.emitter;
        String label = emitter.particles.size() + "P - " + emitter.age + "A";
        this.font.func_175063_a(label, (float)(this.area.x + 4), (float)(this.area.ey() - 12), 0xFFFFFF);
        if (this.modal.isVisible()) {
            this.open.area.draw(-2013265920);
            this.modal.area.draw(-2013265920);
        }
    }
}

