/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.particles.components.appearance;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import mchorse.blockbuster.client.particles.components.BedrockComponentBase;
import mchorse.blockbuster.client.particles.components.IComponentParticleInitialize;
import mchorse.blockbuster.client.particles.components.IComponentParticleMorphRender;
import mchorse.blockbuster.client.particles.emitter.BedrockEmitter;
import mchorse.blockbuster.client.particles.emitter.BedrockParticle;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.math.molang.MolangException;
import mchorse.mclib.math.molang.MolangParser;
import mchorse.mclib.utils.Interpolations;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BedrockComponentParticleMorph
extends BedrockComponentBase
implements IComponentParticleMorphRender,
IComponentParticleInitialize {
    public boolean enabled;
    public boolean renderTexture;
    public Morph morph = new Morph();

    @Override
    public BedrockComponentBase fromJson(JsonElement elem, MolangParser parser) throws MolangException {
        if (!elem.isJsonObject()) {
            return super.fromJson(elem, parser);
        }
        JsonObject element = elem.getAsJsonObject();
        if (element.has("enabled")) {
            this.enabled = element.get("enabled").getAsBoolean();
        }
        if (element.has("render_texture")) {
            this.renderTexture = element.get("render_texture").getAsBoolean();
        }
        if (element.has("nbt")) {
            try {
                this.morph.setDirect(MorphManager.INSTANCE.morphFromNBT(JsonToNBT.func_180713_a((String)element.get("nbt").getAsString())));
            }
            catch (NBTException nBTException) {
                // empty catch block
            }
        }
        return super.fromJson((JsonElement)element, parser);
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("enabled", Boolean.valueOf(this.enabled));
        object.addProperty("render_texture", Boolean.valueOf(this.renderTexture));
        if (!this.morph.isEmpty()) {
            object.addProperty("nbt", this.morph.toNBT().toString());
        }
        return object;
    }

    @Override
    public void apply(BedrockEmitter emitter, BedrockParticle particle) {
        if (this.enabled && !this.morph.isEmpty()) {
            particle.morph.set(MorphUtils.copy((AbstractMorph)this.morph.get()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(BedrockEmitter emitter, BedrockParticle particle, BufferBuilder builder, float partialTicks) {
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        if (camera == null || this.morph.isEmpty() || !this.enabled) {
            return;
        }
        EntityLivingBase dummy = particle.getDummy(emitter);
        double x = Interpolations.lerp((double)particle.prevPosition.x, (double)particle.position.x, (double)partialTicks);
        double y = Interpolations.lerp((double)particle.prevPosition.y, (double)particle.position.y, (double)partialTicks);
        double z = Interpolations.lerp((double)particle.prevPosition.z, (double)particle.position.z, (double)partialTicks);
        Vector3d position = this.calculatePosition(emitter, particle, x, y, z);
        x = position.x;
        y = position.y;
        z = position.z;
        if (!GuiModelRenderer.isRendering()) {
            x -= Interpolations.lerp((double)camera.field_70169_q, (double)camera.field_70165_t, (double)partialTicks);
            y -= Interpolations.lerp((double)camera.field_70167_r, (double)camera.field_70163_u, (double)partialTicks);
            z -= Interpolations.lerp((double)camera.field_70166_s, (double)camera.field_70161_v, (double)partialTicks);
        }
        int combinedBrightness = dummy.func_70070_b();
        int brightnessX = combinedBrightness % 65536;
        int brightnessY = combinedBrightness / 65536;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)brightnessX, (float)brightnessY);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (particle.relativeScaleBillboard) {
            GlStateManager.func_179139_a((double)emitter.scale[0], (double)emitter.scale[1], (double)emitter.scale[2]);
        }
        MorphUtils.render((AbstractMorph)this.morph.get(), (EntityLivingBase)dummy, (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)partialTicks);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    protected Vector3d calculatePosition(BedrockEmitter emitter, BedrockParticle particle, double px, double py, double pz) {
        if (particle.relativePosition && particle.relativeRotation) {
            Vector3f vector = new Vector3f((float)px, (float)py, (float)pz);
            emitter.rotation.transform((Tuple3f)vector);
            px = vector.x;
            py = vector.y;
            pz = vector.z;
            if (particle.relativeScale) {
                Vector3d pos = new Vector3d(px, py, pz);
                Matrix3d scale = new Matrix3d(emitter.scale[0], 0.0, 0.0, 0.0, emitter.scale[1], 0.0, 0.0, 0.0, emitter.scale[2]);
                scale.transform((Tuple3d)pos);
                px = pos.x;
                py = pos.y;
                pz = pos.z;
            }
            px += emitter.lastGlobal.x;
            py += emitter.lastGlobal.y;
            pz += emitter.lastGlobal.z;
        } else if (particle.relativeScale) {
            Vector3d pos = new Vector3d(px, py, pz);
            Matrix3d scale = new Matrix3d(emitter.scale[0], 0.0, 0.0, 0.0, emitter.scale[1], 0.0, 0.0, 0.0, emitter.scale[2]);
            pos.sub((Tuple3d)emitter.lastGlobal);
            scale.transform((Tuple3d)pos);
            pos.add((Tuple3d)emitter.lastGlobal);
            px = pos.x;
            py = pos.y;
            pz = pos.z;
        }
        return new Vector3d(px, py, pz);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(BedrockParticle particle, int x, int y, float scale, float partialTicks) {
        if (this.enabled && !particle.morph.isEmpty() && particle.morph.get() != null) {
            particle.morph.get().renderOnScreen((EntityPlayer)Minecraft.func_71410_x().field_71439_g, x, y, scale, 1.0f);
        }
    }

    @Override
    public void preRender(BedrockEmitter emitter, float partialTicks) {
    }

    @Override
    public void postRender(BedrockEmitter emitter, float partialTicks) {
    }

    @Override
    public int getSortingIndex() {
        return 99;
    }
}

