/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.render;

import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.client.RenderingHandler;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster_pack.morphs.CustomMorph;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;

public class RenderActor
extends RenderLiving<EntityActor> {
    private static final ResourceLocation defaultTexture = new ResourceLocation("blockbuster", "textures/entity/actor.png");

    public RenderActor(RenderManager manager, float shadow) {
        super(manager, null, shadow);
    }

    protected ResourceLocation getEntityTexture(EntityActor entity) {
        return defaultTexture;
    }

    public boolean shouldRender(EntityActor livingEntity, ICamera camera, double camX, double camY, double camZ) {
        if (livingEntity.renderLast && Blockbuster.actorAlwaysRender.get()) {
            return false;
        }
        if (Blockbuster.actorAlwaysRender.get()) {
            return true;
        }
        return super.func_177071_a((EntityLiving)livingEntity, camera, camX, camY, camZ);
    }

    public void doRender(EntityActor entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_76987_f = 0.0f;
        if (entity.invisible) {
            this.renderPlayerRecordingName(entity, x, y, z);
            return;
        }
        AbstractMorph morph = entity.getMorph();
        if (morph != null) {
            this.field_76987_f = 1.0f;
            float shadow = 0.5f;
            if (morph instanceof CustomMorph) {
                CustomMorph custom = (CustomMorph)morph;
                if (custom.model != null) {
                    shadow = custom.getWidth((EntityLivingBase)entity) * custom.model.scale[0];
                }
            }
            this.field_76989_e = shadow;
            morph.render((EntityLivingBase)entity, x, y, z, entityYaw, partialTicks);
        }
        this.func_110827_b((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        this.renderPlayerRecordingName(entity, x, y, z);
        if (entity.playback != null && entity.playback.record != null) {
            RenderingHandler.recordsToRender.add(entity.playback.record);
        }
    }

    private void renderPlayerRecordingName(EntityActor entity, double x, double y, double z) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        double maxDistance = 64.0;
        double d0 = entity.func_70068_e(this.field_76990_c.field_78734_h);
        if (d0 <= 4096.0 && entity.playback != null && entity.playback.record != null) {
            float viewerYaw = this.field_76990_c.field_78735_i;
            float viewerPitch = this.field_76990_c.field_78732_j;
            boolean isThirdPersonFrontal = this.field_76990_c.field_78733_k.field_74320_O == 2;
            float f2 = entity.field_70131_O / 2.0f;
            String str = entity.playback.record.filename;
            FontRenderer fontRendererIn = this.func_76983_a();
            int verticalShift = -fontRendererIn.field_78288_b / 2;
            y += (double)f2;
            int shader = GL11.glGetInteger((int)35725);
            if (shader != 0) {
                OpenGlHelper.func_153161_d((int)0);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(isThirdPersonFrontal ? -1 : 1) * viewerPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            int i = fontRendererIn.func_78256_a(str) / 2;
            GlStateManager.func_179090_x();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            vertexbuffer.func_181662_b((double)(-i - 1), (double)(-1 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            vertexbuffer.func_181662_b((double)(-i - 1), (double)(8 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            vertexbuffer.func_181662_b((double)(i + 1), (double)(8 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            vertexbuffer.func_181662_b((double)(i + 1), (double)(-1 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            fontRendererIn.func_78276_b(str, -fontRendererIn.func_78256_a(str) / 2, verticalShift, -1);
            GlStateManager.func_179126_j();
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            if (shader != 0) {
                OpenGlHelper.func_153161_d((int)shader);
            }
        }
    }

    public static class FactoryActor
    implements IRenderFactory<EntityActor> {
        public RenderActor createRenderFor(RenderManager manager) {
            return new RenderActor(manager, 0.5f);
        }
    }
}

