/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.model;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.commands.BBCommandBase;
import mchorse.blockbuster.utils.TextureUtils;
import mchorse.mclib.utils.files.GlobalTree;
import mchorse.mclib.utils.files.entries.AbstractEntry;
import mchorse.mclib.utils.files.entries.FileEntry;
import mchorse.mclib.utils.files.entries.FolderEntry;
import mchorse.mclib.utils.resources.FilteredResourceLocation;
import mchorse.mclib.utils.resources.MultiResourceLocation;
import mchorse.mclib.utils.resources.RLUtils;
import mchorse.mclib.utils.resources.TextureProcessor;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

public class SubCommandModelCombine
extends BBCommandBase {
    public String func_71517_b() {
        return "combine";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.model.combine";
    }

    public String getSyntax() {
        return "{l}{6}/{r}model {8}combine{r} {7}<paths...>{r}";
    }

    public int getRequiredArgs() {
        return 1;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        ArrayList<MultiResourceLocation> toExport = new ArrayList<MultiResourceLocation>();
        ArrayList<FolderEntry> entries = new ArrayList<FolderEntry>();
        for (String path : args) {
            FolderEntry entry = GlobalTree.TREE.getByPath("b.a/" + path, null);
            if (entry == null) continue;
            entries.add(entry);
        }
        if (entries.isEmpty()) {
            Blockbuster.l10n.error(sender, "commands.combining_empty", new Object[]{toExport.size()});
            return;
        }
        this.generate(toExport, entries);
        if (toExport.isEmpty()) {
            Blockbuster.l10n.error(sender, "commands.combining_folders_empty", new Object[]{toExport.size()});
            return;
        }
        Blockbuster.l10n.info(sender, "commands.started_combining", new Object[]{toExport.size()});
        try {
            new Thread(new CombineThread(sender, toExport)).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void generate(List<MultiResourceLocation> toExport, List<FolderEntry> entries) {
        this.generateRLs(entries, entries.get(0), 0, "", string -> {
            String[] splits = string.substring(1).split("!");
            MultiResourceLocation location = new MultiResourceLocation();
            for (String split : splits) {
                location.children.add(new FilteredResourceLocation(RLUtils.create((String)split)));
            }
            toExport.add(location);
        });
    }

    private void generateRLs(List<FolderEntry> entries, FolderEntry folder, int index, String prefix, Consumer<String> callback) {
        for (AbstractEntry entry : folder.getEntries()) {
            if (!(entry instanceof FileEntry)) continue;
            FileEntry file = (FileEntry)entry;
            if (index == entries.size() - 1) {
                callback.accept(prefix + "!" + file.resource);
                continue;
            }
            this.generateRLs(entries, entries.get(index + 1), index + 1, prefix + "!" + file.resource, callback);
        }
    }

    public static class CombineThread
    implements Runnable {
        public ICommandSender sender;
        public List<MultiResourceLocation> locations;

        public CombineThread(ICommandSender sender, List<MultiResourceLocation> locations) {
            this.sender = sender;
            this.locations = locations;
        }

        @Override
        public void run() {
            int i = 0;
            for (MultiResourceLocation location : this.locations) {
                try {
                    BufferedImage image = TextureProcessor.process((MultiResourceLocation)location);
                    File folder = new File(ClientProxy.configFile, "export");
                    File file = TextureUtils.getFirstAvailableFile(folder, "combined_" + i);
                    folder.mkdirs();
                    ImageIO.write((RenderedImage)image, "png", file);
                    Blockbuster.l10n.info(this.sender, "commands.combined", new Object[]{i});
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            Blockbuster.l10n.info(this.sender, "commands.finished_combining", new Object[0]);
        }
    }
}

