/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.model;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.imageio.ImageIO;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.ModelPose;
import mchorse.blockbuster.client.model.ModelCustom;
import mchorse.blockbuster.client.model.parsing.ModelExporterOBJ;
import mchorse.blockbuster.commands.BBCommandBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.io.FileUtils;

public class SubCommandModelExportObj
extends BBCommandBase {
    public String func_71517_b() {
        return "export_obj";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.model.export_obj";
    }

    public String getSyntax() {
        return "{l}{6}/{r}model {8}export_obj{r} {7}<model_name> [pose]{r}";
    }

    public int getRequiredArgs() {
        return 1;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String modelName = args[0];
        ModelCustom model = ModelCustom.MODELS.get(modelName);
        if (model == null) {
            throw new CommandException("blockbuster.error.model.export.no_model", new Object[]{modelName});
        }
        Model data = model.model;
        ModelPose pose = args.length >= 2 ? data.getPose(args[1]) : data.getPose("standing");
        String obj = new ModelExporterOBJ(data, pose).export(modelName);
        String filename = modelName.replaceAll("[^\\w\\d_-]", "_");
        File destination = new File(CommonProxy.configFile, "export/" + filename + ".obj");
        if (data.defaultTexture != null) {
            try {
                String mtl = "# MTL generated by Blockbuster (version 2.3.3)\n\nnewmtl default\nKd 1.000000 1.000000 1.000000\nNi 1.000000\nd 1.000000\nillum 2\nmap_Kd " + filename + ".png";
                File mtlFile = new File(CommonProxy.configFile, "export/" + filename + ".mtl");
                FileUtils.writeStringToFile((File)mtlFile, (String)mtl, (Charset)Charset.defaultCharset());
            }
            catch (Exception mtl) {
                // empty catch block
            }
            try {
                IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(data.defaultTexture);
                BufferedImage image = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
                File texture = new File(CommonProxy.configFile, "export/" + filename + ".png");
                ImageIO.write((RenderedImage)image, "png", texture);
            }
            catch (Exception resource) {
                // empty catch block
            }
        }
        try {
            FileUtils.writeStringToFile((File)destination, (String)obj, (Charset)Charset.defaultCharset());
            Blockbuster.l10n.success(sender, "model.export.obj", new Object[]{modelName});
        }
        catch (Exception e) {
            e.printStackTrace();
            Blockbuster.l10n.error(sender, "model.export.obj", new Object[]{modelName});
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return SubCommandModelExportObj.func_175762_a((String[])args, ModelCustom.MODELS.keySet());
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

