/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.commands.CommandRecord;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.actions.SwipeAction;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Record;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;

public class SubCommandRecordCalculateBodyYaw
extends SubCommandRecordBase {
    public String func_71517_b() {
        return "calculate_body_yaw";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.calculate_body_yaw";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}calculate_body_yaw{r} {7}<filename>{r}";
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String filename = args[0];
        Record record = CommandRecord.getRecord(filename);
        Frame prev = null;
        float renderYawOffset = 0.0f;
        int swingProgress = 0;
        int c = record.frames.size();
        for (int i = 0; i < c; ++i) {
            float coolBob;
            float anotherCoolBob;
            Frame frame = record.frames.get(i);
            List<Action> actions = record.getActions(i);
            if (actions != null) {
                for (Action action : actions) {
                    if (!(action instanceof SwipeAction)) continue;
                    swingProgress = 6;
                }
            }
            if (prev == null) {
                prev = frame;
                renderYawOffset = prev.yaw;
            }
            double dx = frame.x - prev.x;
            double dz = frame.z - prev.z;
            float distSq = (float)(dx * dx + dz * dz);
            float tempRenderyawOffset = renderYawOffset;
            if (distSq > 0.0025000002f) {
                float f1 = (float)MathHelper.func_181159_b((double)dz, (double)dx) * 57.295776f - 90.0f;
                float f2 = MathHelper.func_76135_e((float)(MathHelper.func_76142_g((float)frame.yaw) - f1));
                tempRenderyawOffset = 95.0f < f2 && f2 < 265.0f ? f1 - 180.0f : f1;
            }
            if (swingProgress > 0) {
                renderYawOffset = frame.yaw;
            }
            if ((anotherCoolBob = MathHelper.func_76142_g((float)(frame.yaw - (renderYawOffset += (coolBob = MathHelper.func_76142_g((float)(tempRenderyawOffset - renderYawOffset))) * 0.3f)))) < -75.0f) {
                anotherCoolBob = -75.0f;
            }
            if (anotherCoolBob >= 75.0f) {
                anotherCoolBob = 75.0f;
            }
            renderYawOffset = frame.yaw - anotherCoolBob;
            if (anotherCoolBob * anotherCoolBob > 2500.0f) {
                renderYawOffset += anotherCoolBob * 0.2f;
            }
            frame.hasBodyYaw = true;
            frame.bodyYaw = renderYawOffset;
            prev = frame;
            --swingProgress;
        }
        RecordUtils.dirtyRecord(record);
        Blockbuster.l10n.success(sender, "record.calculate_body_yaw", new Object[]{filename});
    }
}

