/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import java.util.Arrays;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.commands.CommandRecord;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Record;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class SubCommandRecordFlip
extends SubCommandRecordBase {
    public static List<String> ALLOWED_AXES = Arrays.asList("x", "z");

    public String func_71517_b() {
        return "flip";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.flip";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}flip{r} {7}<filename> <axis:X|Z> <coordinate> [center]{r}";
    }

    @Override
    public int getRequiredArgs() {
        return 3;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Record record = CommandRecord.getRecord(args[0]);
        String axis = args[1].toLowerCase();
        boolean center = args.length < 4 ? true : CommandBase.func_180527_d((String)args[3]);
        double coordinate = (double)CommandBase.func_175755_a((String)args[2]) + (center ? 0.5 : 0.0);
        if (!ALLOWED_AXES.contains(axis)) {
            Blockbuster.l10n.error(sender, "record.wrong_axis", new Object[]{args[1]});
            return;
        }
        for (Frame frame : record.frames) {
            double diff;
            if (axis.equals("x")) {
                diff = coordinate - frame.x;
                frame.x = coordinate + diff;
                frame.yaw *= -1.0f;
                frame.yawHead *= -1.0f;
                frame.mountYaw *= -1.0f;
                continue;
            }
            diff = coordinate - frame.z;
            frame.z = coordinate + diff;
            frame.yaw = -frame.yaw + 180.0f;
            frame.yawHead = -frame.yawHead + 180.0f;
            frame.mountYaw = -frame.mountYaw + 180.0f;
        }
        for (List list : record.actions) {
            if (list == null) continue;
            for (Action action : list) {
                action.flip(axis, center ? Math.floor(coordinate) : coordinate - 0.5);
            }
        }
        try {
            RecordUtils.saveRecord(record);
            Blockbuster.l10n.success(sender, "record.flipped", new Object[]{args[0], args[1], args[2]});
        }
        catch (Exception e) {
            e.printStackTrace();
            Blockbuster.l10n.error(sender, "record.couldnt_save", new Object[]{args[1]});
        }
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 2) {
            return SubCommandRecordFlip.func_175762_a((String[])args, ALLOWED_AXES);
        }
        if (args.length == 3 && ALLOWED_AXES.contains(args[1])) {
            Vec3d vec3d = sender.func_174791_d();
            int coordinate = (int)Math.floor(args[1].equals("x") ? vec3d.field_72450_a : vec3d.field_72449_c);
            return SubCommandRecordFlip.func_175762_a((String[])args, Arrays.asList(coordinate));
        }
        if (args.length == 4) {
            return SubCommandRecordFlip.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

