/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import java.util.Collection;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.commands.CommandRecord;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.actions.ActionRegistry;
import mchorse.blockbuster.recording.data.Record;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class SubCommandRecordSearch
extends SubCommandRecordBase {
    public String func_71517_b() {
        return "search";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.search";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}search{r} {7}<filename> <action_type> [limit] [output_tags]{r}";
    }

    @Override
    public int getRequiredArgs() {
        return 2;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int temp;
        boolean outputData;
        if (!ActionRegistry.NAME_TO_CLASS.containsKey((Object)args[1])) {
            throw new CommandException("record.wrong_action", new Object[]{args[1]});
        }
        String filename = args[0];
        byte type = ActionRegistry.NAME_TO_ID.get(args[1]);
        Record record = CommandRecord.getRecord(filename);
        int i = 0;
        int tick = -1;
        int limit = record.actions.size() + 1;
        boolean bl = outputData = args.length >= 4 ? CommandBase.func_180527_d((String)args[3]) : false;
        if (args.length >= 3 && (temp = CommandBase.func_180528_a((String)args[2], (int)-1)) >= 0) {
            limit = temp;
        }
        Blockbuster.l10n.info(sender, "record.search_type", new Object[]{args[1]});
        for (List<Action> actions : record.actions) {
            ++tick;
            if (actions == null) continue;
            if (i >= limit) break;
            int j = -1;
            for (Action action : actions) {
                ++j;
                if (ActionRegistry.getType(action) != type) continue;
                if (outputData) {
                    NBTTagCompound tag = new NBTTagCompound();
                    action.toNBT(tag);
                    Blockbuster.l10n.info(sender, "record.search_action_data", new Object[]{tick, j, tag.toString()});
                    continue;
                }
                Blockbuster.l10n.info(sender, "record.search_action", new Object[]{tick, j});
            }
            ++i;
        }
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 2) {
            return SubCommandRecordSearch.func_175762_a((String[])args, (Collection)ActionRegistry.NAME_TO_CLASS.keySet());
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

