/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.common;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import mchorse.blockbuster.client.RenderingHandler;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class OrientedBB {
    private Vector3d w = new Vector3d(1.0, 0.0, 0.0);
    private Vector3d u = new Vector3d(0.0, 1.0, 0.0);
    private Vector3d v = new Vector3d(0.0, 0.0, 1.0);
    private Vector3d anchorPoint = new Vector3d();
    public static Matrix4f modelView = new Matrix4f();
    public Matrix3d scale = new Matrix3d();
    public Matrix3d rotation = new Matrix3d();
    public double[] rotation0 = new double[]{0.0, 0.0, 0.0};
    public Vector3d center = new Vector3d();
    public double hw;
    public double hu;
    public double hv;
    public Corner[] corners = new Corner[8];
    public Vector3d limbOffset = new Vector3d();
    public Vector3d anchorOffset = new Vector3d();
    public Vector3d offset = new Vector3d();

    public OrientedBB(@Nullable Vector3d center, @Nullable double[] rotation0, float width, float height, float depth) {
        if (center == null) {
            center = new Vector3d();
        }
        if (rotation0 == null) {
            rotation0 = new double[3];
        }
        this.setup(rotation0, width, height, depth);
        this.center.set((Tuple3d)center);
    }

    public OrientedBB() {
        double[] rotation0 = new double[3];
        this.rotation.setIdentity();
        this.setup(rotation0, 0.0f, 0.0f, 0.0f);
        this.buildCorners();
    }

    public void setup(double[] rotation0, float width, float height, float depth) {
        this.center = new Vector3d();
        this.hw = Math.abs(width) / 2.0f;
        this.hu = Math.abs(height) / 2.0f;
        this.hv = Math.abs(depth) / 2.0f;
        this.rotation0 = rotation0;
        RenderingHandler.obbsToRender.add(this);
        this.rotation.setIdentity();
        this.scale.setIdentity();
    }

    public void render(RenderWorldLastEvent event) {
        Corner[] startCorners;
        int shader = GL11.glGetInteger((int)35725);
        if (shader != 0) {
            OpenGlHelper.func_153161_d((int)0);
        }
        Color color = ColorUtils.COLOR;
        Entity player = Minecraft.func_71410_x().func_175606_aa();
        double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialTicks();
        double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialTicks();
        double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialTicks();
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        color.set(1.0f, 1.0f, 1.0f, 1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_178969_c(-playerX, -playerY, -playerZ);
        builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        for (Corner start : startCorners = new Corner[]{this.corners[0], this.corners[2], this.corners[5], this.corners[7]}) {
            for (Corner end : start.connections) {
                builder.func_181662_b(start.position.x, start.position.y, start.position.z).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                builder.func_181662_b(end.position.x, end.position.y, end.position.z).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
            }
        }
        builder.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        this.renderAxes(new double[]{-playerX, -playerY, -playerZ}, color, this.anchorPoint, 4.0, true, false);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_187441_d((float)1.0f);
        if (shader != 0) {
            OpenGlHelper.func_153161_d((int)shader);
        }
    }

    public void renderAxes(double[] translation, Color color, Vector3d center0, double length, boolean rotate, boolean depth) {
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        if (!depth) {
            GlStateManager.func_179097_i();
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_178969_c(translation[0], translation[1], translation[2]);
        builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        Matrix3d rotation0 = OrientedBB.anglesToMatrix(this.rotation0[0], this.rotation0[1], this.rotation0[2]);
        Vector3d axisX1 = new Vector3d(length /= 32.0, 0.0, 0.0);
        Vector3d axisX2 = new Vector3d(0.0, length, 0.0);
        Vector3d axisX3 = new Vector3d(0.0, 0.0, length);
        if (rotate) {
            this.rotation.transform((Tuple3d)axisX1);
            rotation0.transform((Tuple3d)axisX1);
            this.rotation.transform((Tuple3d)axisX2);
            rotation0.transform((Tuple3d)axisX2);
            this.rotation.transform((Tuple3d)axisX3);
            rotation0.transform((Tuple3d)axisX3);
        }
        builder.func_181662_b(center0.x + axisX1.x, center0.y + axisX1.y, center0.z + axisX1.z).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        builder.func_181662_b(center0.x - axisX1.x, center0.y - axisX1.y, center0.z - axisX1.z).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        builder.func_181662_b(center0.x + axisX2.x, center0.y + axisX2.y, center0.z + axisX2.z).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        builder.func_181662_b(center0.x - axisX2.x, center0.y - axisX2.y, center0.z - axisX2.z).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        builder.func_181662_b(center0.x + axisX3.x, center0.y + axisX3.y, center0.z + axisX3.z).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        builder.func_181662_b(center0.x - axisX3.x, center0.y - axisX3.y, center0.z - axisX3.z).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        builder.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        if (!depth) {
            GlStateManager.func_179126_j();
        }
    }

    public void buildCorners() {
        Corner maxXminYZ;
        Corner minXYZ;
        Corner minXYmaxZ;
        Corner maxXminYmaxZ;
        Corner maxXYminZ;
        Corner minXmaxYminZ;
        Corner minXmaxYZ;
        Corner maxXYZ;
        if (!RenderingHandler.obbsToRender.contains(this)) {
            RenderingHandler.obbsToRender.add(this);
        }
        Vector3d width = new Vector3d(this.w);
        Vector3d height = new Vector3d(this.u);
        Vector3d depth = new Vector3d(this.v);
        Matrix3d rotation0 = OrientedBB.anglesToMatrix(this.rotation0[0], this.rotation0[1], this.rotation0[2]);
        width.scale(this.hw);
        height.scale(this.hu);
        depth.scale(this.hv);
        Vector3d limbOffset0 = new Vector3d(this.limbOffset);
        Vector3d anchorOffset0 = new Vector3d(this.anchorOffset);
        Vector3d offset0 = new Vector3d(this.offset);
        Matrix3d rotscale = new Matrix3d(this.scale);
        rotscale.mul(this.rotation);
        rotscale.mul(rotation0);
        this.rotation.transform((Tuple3d)limbOffset0);
        this.scale.transform((Tuple3d)limbOffset0);
        rotscale.transform((Tuple3d)anchorOffset0);
        rotscale.transform((Tuple3d)width);
        rotscale.transform((Tuple3d)height);
        rotscale.transform((Tuple3d)depth);
        Vector3d center = new Vector3d(this.center);
        center.add((Tuple3d)offset0);
        this.anchorPoint.set((Tuple3d)center);
        center.add((Tuple3d)anchorOffset0);
        center.add((Tuple3d)limbOffset0);
        Vector3d pos = new Vector3d(center);
        pos.add((Tuple3d)width);
        pos.add((Tuple3d)height);
        pos.add((Tuple3d)depth);
        this.corners[0] = maxXYZ = new Corner(pos);
        pos.set((Tuple3d)center);
        pos.sub((Tuple3d)width);
        pos.add((Tuple3d)height);
        pos.add((Tuple3d)depth);
        this.corners[1] = minXmaxYZ = new Corner(pos);
        pos.set((Tuple3d)center);
        pos.sub((Tuple3d)width);
        pos.add((Tuple3d)height);
        pos.sub((Tuple3d)depth);
        this.corners[2] = minXmaxYminZ = new Corner(pos);
        pos.set((Tuple3d)center);
        pos.add((Tuple3d)width);
        pos.add((Tuple3d)height);
        pos.sub((Tuple3d)depth);
        this.corners[3] = maxXYminZ = new Corner(pos);
        pos.set((Tuple3d)center);
        pos.add((Tuple3d)width);
        pos.sub((Tuple3d)height);
        pos.add((Tuple3d)depth);
        this.corners[4] = maxXminYmaxZ = new Corner(pos);
        pos.set((Tuple3d)center);
        pos.sub((Tuple3d)width);
        pos.sub((Tuple3d)height);
        pos.add((Tuple3d)depth);
        this.corners[5] = minXYmaxZ = new Corner(pos);
        pos.set((Tuple3d)center);
        pos.sub((Tuple3d)width);
        pos.sub((Tuple3d)height);
        pos.sub((Tuple3d)depth);
        this.corners[6] = minXYZ = new Corner(pos);
        pos.set((Tuple3d)center);
        pos.add((Tuple3d)width);
        pos.sub((Tuple3d)height);
        pos.sub((Tuple3d)depth);
        this.corners[7] = maxXminYZ = new Corner(pos);
        maxXYZ.connect(maxXYminZ);
        maxXYZ.connect(minXmaxYZ);
        maxXYZ.connect(maxXminYmaxZ);
        minXmaxYminZ.connect(maxXYminZ);
        minXmaxYminZ.connect(minXYZ);
        minXmaxYminZ.connect(minXmaxYZ);
        minXYmaxZ.connect(maxXminYmaxZ);
        minXYmaxZ.connect(minXYZ);
        minXYmaxZ.connect(minXmaxYZ);
        maxXminYZ.connect(maxXYminZ);
        maxXminYZ.connect(minXYZ);
        maxXminYZ.connect(maxXminYmaxZ);
    }

    public static Matrix3d anglesToMatrix(double angleX, double angleY, double angleZ) {
        double radX = Math.toRadians(angleX);
        double radY = Math.toRadians(angleY);
        double radZ = Math.toRadians(angleZ);
        Matrix3d rotation = new Matrix3d();
        Matrix3d rot = new Matrix3d();
        rotation.setIdentity();
        rot.rotX(radX);
        rotation.mul(rot);
        rot.rotY(radY);
        rotation.mul(rot);
        rot.rotZ(radZ);
        rotation.mul(rot);
        return rotation;
    }

    public OrientedBB clone() {
        OrientedBB d = new OrientedBB();
        d.hu = this.hu;
        d.hw = this.hw;
        d.hv = this.hv;
        d.anchorOffset.set((Tuple3d)this.anchorOffset);
        d.offset.set((Tuple3d)this.offset);
        d.center.set((Tuple3d)this.center);
        d.limbOffset.set((Tuple3d)this.limbOffset);
        d.rotation.set(this.rotation);
        d.rotation0 = this.rotation0;
        d.scale.set(this.scale);
        return d;
    }

    public String toString() {
        return "OBB - center: " + this.center;
    }

    private class Corner {
        public Vector3d position;
        private List<Corner> connections;

        public Corner(Vector3d pos) {
            this.position = new Vector3d(pos);
            this.connections = new ArrayList<Corner>();
        }

        public boolean connect(Corner corner) {
            if (!corner.connections.contains(this) && !this.connections.contains(corner)) {
                corner.connections.add(this);
                this.connections.add(corner);
                return true;
            }
            if (!corner.connections.contains(this)) {
                corner.connections.add(this);
                return true;
            }
            if (!this.connections.contains(corner)) {
                this.connections.add(corner);
                return true;
            }
            return false;
        }

        public boolean disconnect(Corner corner) {
            if (corner.connections.contains(this) && this.connections.contains(corner)) {
                corner.connections.remove(this);
                this.connections.remove(corner);
                return true;
            }
            if (corner.connections.contains(this)) {
                corner.connections.remove(this);
                return true;
            }
            if (this.connections.contains(corner)) {
                this.connections.remove(corner);
                return true;
            }
            return false;
        }
    }
}

