/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.common.block;

import java.lang.reflect.Field;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.common.tileentity.TileEntityDirector;
import mchorse.blockbuster.utils.EntityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDirector
extends Block
implements ITileEntityProvider {
    public static final PropertyBool PLAYING = PropertyBool.func_177716_a((String)"playing");
    public static final PropertyBool HIDDEN = PropertyBool.func_177716_a((String)"hidden");

    public BlockDirector() {
        super(Material.field_151576_e);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)PLAYING, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)HIDDEN, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(Blockbuster.blockbusterTab);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.setRegistryName("director");
        this.func_149663_c("blockbuster.director");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"blockbuster.info.director_block", (Object[])new Object[0]));
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HIDDEN) == false;
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HIDDEN) == false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HIDDEN) != false ? EnumBlockRenderType.ENTITYBLOCK_ANIMATED : super.func_149645_b(state);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)HIDDEN) != false ? null : super.func_180646_a(state, worldIn, pos);
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Boolean)state.func_177229_b((IProperty)PLAYING) != false ? 0 : 1;
        return meta |= (Boolean)state.func_177229_b((IProperty)HIDDEN) != false ? 2 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PLAYING, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a((IProperty)HIDDEN, (Comparable)Boolean.valueOf((meta & 2) == 2));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PLAYING, HIDDEN});
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        boolean isPlaying = (Boolean)blockState.func_177229_b((IProperty)PLAYING);
        return isPlaying && side == EnumFacing.WEST || !isPlaying && side == EnumFacing.EAST ? 15 : 0;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            EntityUtils.sendStatusMessage((EntityPlayerMP)playerIn, (ITextComponent)new TextComponentTranslation("blockbuster.bye_director_block", new Object[0]));
            TextComponentTranslation link = new TextComponentTranslation("blockbuster.bye_director_block_guide", new Object[0]);
            TextComponentTranslation youtube = new TextComponentTranslation("blockbuster.bye_director_block_guide_watch", new Object[0]);
            String url = this.getUrl(playerIn);
            youtube.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
            youtube.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(url)));
            youtube.func_150256_b().func_150238_a(TextFormatting.GRAY).func_150228_d(Boolean.valueOf(true));
            playerIn.func_145747_a(link.func_150257_a((ITextComponent)youtube).func_150257_a((ITextComponent)new TextComponentString(".")));
        }
        return true;
    }

    private String getUrl(EntityPlayer playerIn) {
        Field field = null;
        for (Field member : EntityPlayerMP.class.getDeclaredFields()) {
            if (member.getType() != String.class) continue;
            field = member;
            break;
        }
        if (field != null) {
            try {
                field.setAccessible(true);
                String language = (String)field.get(playerIn);
                if (language.startsWith("zh_")) {
                    return "https://bilibili.com/video/BV1SV41117Pm";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "https://youtu.be/nMOb8RnuyuE";
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDirector();
    }
}

