/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.common.item;

import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.common.GunProps;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.common.entity.EntityGunProjectile;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.guns.PacketGunShot;
import mchorse.blockbuster.utils.NBTUtils;
import mchorse.blockbuster_pack.morphs.SequencerMorph;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ItemGun
extends Item {
    public ItemGun() {
        this.func_77625_d(1);
        this.setRegistryName("gun");
        this.func_77655_b("blockbuster.gun");
        this.func_77637_a(Blockbuster.blockbusterTab);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        return new ActionResult(this.shootIt(stack, player, world), (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        return this.shootIt(stack, player, world);
    }

    public EnumActionResult shootIt(ItemStack stack, EntityPlayer player, World world) {
        GunProps props = NBTUtils.getGunProps(stack);
        if (world.field_72995_K) {
            if (props != null && props.launch) {
                float pitch = player.field_70125_A + (float)((Math.random() - 0.5) * (double)props.scatterY);
                float yaw = player.field_70177_z + (float)((Math.random() - 0.5) * (double)props.scatterX);
                this.setThrowableHeading((EntityLivingBase)player, pitch, yaw, 0.0f, props.speed);
            }
            return EnumActionResult.PASS;
        }
        return this.shoot(stack, props, player, world) ? EnumActionResult.PASS : EnumActionResult.FAIL;
    }

    public boolean shoot(ItemStack stack, GunProps props, EntityPlayer player, World world) {
        if (props == null) {
            return false;
        }
        if (props.launch) {
            float pitch = player.field_70125_A + (float)((Math.random() - 0.5) * (double)props.scatterY);
            float yaw = player.field_70177_z + (float)((Math.random() - 0.5) * (double)props.scatterX);
            this.setThrowableHeading((EntityLivingBase)player, pitch, yaw, 0.0f, props.speed);
            if (!props.fireCommand.isEmpty()) {
                player.func_184102_h().field_71321_q.func_71556_a((ICommandSender)player, props.fireCommand);
            }
        } else {
            ItemStack ammo;
            if (!(player.field_71075_bZ.field_75098_d || props.ammoStack.func_190926_b() || this.consumeAmmoStack(player, ammo = props.ammoStack))) {
                return false;
            }
            EntityGunProjectile last = null;
            for (int i = 0; i < Math.max(props.projectiles, 1); ++i) {
                AbstractMorph morph = props.projectileMorph;
                if (props.sequencer && morph instanceof SequencerMorph) {
                    SequencerMorph seq = (SequencerMorph)morph;
                    morph = props.random ? seq.getRandom() : seq.get(i % seq.morphs.size());
                }
                morph = MorphUtils.copy((AbstractMorph)morph);
                EntityGunProjectile projectile = new EntityGunProjectile(world, props, morph);
                float pitch = player.field_70125_A + (float)((Math.random() - 0.5) * (double)props.scatterY);
                float yaw = player.field_70177_z + (float)((Math.random() - 0.5) * (double)props.scatterX);
                projectile.func_70107_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
                projectile.func_184538_a((Entity)player, pitch, yaw, 0.0f, props.speed, 0.0f);
                projectile.setInitialMotion();
                if (props.projectiles > 0) {
                    world.func_72838_d((Entity)projectile);
                }
                last = projectile;
            }
            if (!props.fireCommand.isEmpty()) {
                player.func_184102_h().field_71321_q.func_71556_a(last, props.fireCommand);
            }
        }
        EntityPlayer entity = player instanceof EntityActor.EntityFakePlayer ? ((EntityActor.EntityFakePlayer)player).actor : player;
        int id = entity.func_145782_y();
        if (player instanceof EntityPlayerMP) {
            Dispatcher.sendTo(new PacketGunShot(id), (EntityPlayerMP)player);
        }
        Dispatcher.sendToTracked((Entity)entity, new PacketGunShot(id));
        return true;
    }

    private boolean consumeAmmoStack(EntityPlayer player, ItemStack ammo) {
        ItemStack stack;
        int total = 0;
        int c = player.field_71071_by.func_70302_i_();
        for (int i = 0; !(i >= c || (stack = player.field_71071_by.func_70301_a(i)).func_77969_a(ammo) && (total += stack.func_190916_E()) >= ammo.func_190916_E()); ++i) {
        }
        if (total < ammo.func_190916_E()) {
            return false;
        }
        return player.field_71071_by.func_174925_a(ammo.func_77973_b(), -1, ammo.func_190916_E(), null) >= 0;
    }

    private void setThrowableHeading(EntityLivingBase entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.setThrowableHeading(entityThrower, (double)f, (double)f1, (double)f2, velocity);
    }

    public void setThrowableHeading(EntityLivingBase entity, double x, double y, double z, float velocity) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        entity.field_70159_w = x *= (double)velocity;
        entity.field_70181_x = y *= (double)velocity;
        entity.field_70179_y = z *= (double)velocity;
    }
}

