/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.core;

import java.util.ListIterator;
import mchorse.blockbuster.core.transformers.EntityRendererTransformer;
import mchorse.blockbuster.core.transformers.EntityTransformationUtilsTransformer;
import mchorse.blockbuster.core.transformers.EntityTransformer;
import mchorse.blockbuster.core.transformers.RenderGlobalTransformer;
import mchorse.blockbuster.core.transformers.RenderItemTransformer;
import mchorse.blockbuster.core.transformers.WorldTransformer;
import mchorse.blockbuster.utils.mclib.coremod.CoreClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class BBCoreClassTransformer
extends CoreClassTransformer {
    private WorldTransformer world = new WorldTransformer();
    private RenderGlobalTransformer render = new RenderGlobalTransformer();
    private EntityRendererTransformer entityRenderer = new EntityRendererTransformer();
    private RenderItemTransformer renderItem = new RenderItemTransformer();
    private EntityTransformer entity = new EntityTransformer();
    private EntityTransformationUtilsTransformer entityTransformationUtils = new EntityTransformationUtilsTransformer();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (BBCoreClassTransformer.checkName(name, "amu", "net.minecraft.world.World")) {
            System.out.println("BBCoreMod: Transforming World class (" + name + ")");
            return this.world.transform(name, basicClass);
        }
        if (BBCoreClassTransformer.checkName(name, "buy", "net.minecraft.client.renderer.RenderGlobal")) {
            System.out.println("BBCoreMod: Transforming RenderGlobal class (" + name + ")");
            return this.render.transform(name, basicClass);
        }
        if (BBCoreClassTransformer.checkName(name, "vg", "net.minecraft.entity.Entity")) {
            System.out.println("BBCoreMod: Transforming Entity class (" + name + ")");
            return this.entity.transform(name, basicClass);
        }
        if (name.equals("mchorse.blockbuster.utils.EntityTransformationUtils")) {
            System.out.println("BBCoreMod: Transforming EntityTransformationUtils class (" + name + ")");
            return this.entityTransformationUtils.transform(name, basicClass);
        }
        if (BBCoreClassTransformer.checkName(name, "buq", "net.minecraft.client.renderer.EntityRenderer")) {
            System.out.println("BBCoreMod: Transforming EntityRenderer class (" + name + ")");
            return this.entityRenderer.transform(name, basicClass);
        }
        if (BBCoreClassTransformer.checkName(name, "bzw", "net.minecraft.client.renderer.RenderItem")) {
            System.out.println("BBCoreMod: Transforming RenderItem class (" + name + ")");
            return this.renderItem.transform(name, basicClass);
        }
        return basicClass;
    }

    public static void debugInstructions(InsnList list) {
        BBCoreClassTransformer.debugInstructions(list, Integer.MAX_VALUE);
    }

    public static void debugInstructions(InsnList list, int max) {
        ListIterator nodes = list.iterator();
        int i = 0;
        while (nodes.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)nodes.next();
            System.out.println("Offset: " + i + " " + node.getClass().getSimpleName() + " " + BBCoreClassTransformer.debugNode(node));
            if (i >= max) break;
            ++i;
        }
    }

    public static String debugNode(AbstractInsnNode node) {
        if (node instanceof LabelNode) {
            return "label " + ((LabelNode)node).getLabel().toString();
        }
        if (node instanceof LineNumberNode) {
            return "line " + String.valueOf(((LineNumberNode)node).line);
        }
        if (node instanceof MethodInsnNode) {
            MethodInsnNode method = (MethodInsnNode)node;
            return method.getOpcode() + " " + method.owner + "." + method.name + ":" + method.desc;
        }
        if (node instanceof FieldInsnNode) {
            FieldInsnNode field = (FieldInsnNode)node;
            return field.getOpcode() + " " + field.owner + "." + field.name + ":" + field.desc;
        }
        if (node instanceof LdcInsnNode) {
            LdcInsnNode ldc = (LdcInsnNode)node;
            return "LDC " + ldc.cst.toString();
        }
        return "opcode " + String.valueOf(node.getOpcode());
    }
}

