/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.core.transformers;

import java.util.ListIterator;
import mchorse.blockbuster.utils.mclib.coremod.ClassTransformer;
import mchorse.blockbuster.utils.mclib.coremod.CoreClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityTransformationUtilsTransformer
extends ClassTransformer {
    @Override
    public void process(String s, ClassNode node) {
        for (MethodNode method : node.methods) {
            String entityDesc = "Lnet/minecraft/entity/Entity;";
            if (method.name.equals("getPrevPrevPosX") && method.desc.equals("(" + entityDesc + ")D")) {
                this.processGetPrevPrevPos(method, "X");
                continue;
            }
            if (method.name.equals("getPrevPrevPosY") && method.desc.equals("(" + entityDesc + ")D")) {
                this.processGetPrevPrevPos(method, "Y");
                continue;
            }
            if (!method.name.equals("getPrevPrevPosZ") || !method.desc.equals("(" + entityDesc + ")D")) continue;
            this.processGetPrevPrevPos(method, "Z");
        }
        System.out.println("BBCoreMod: successfully patched EntityTransformationUtils!");
    }

    public void processGetPrevPrevPos(MethodNode method, String axis) {
        ListIterator it = method.instructions.iterator();
        AbstractInsnNode target = null;
        int index = -1;
        while (it.hasNext()) {
            ++index;
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            if (!(node instanceof InsnNode) || node.getOpcode() != 14) continue;
            target = node;
            break;
        }
        method.instructions.remove(target);
        target = method.instructions.get(index - 1);
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, CoreClassTransformer.get("vg", "net/minecraft/entity/Entity"), "prevPrevPos" + axis, "D"));
        method.instructions.insert(target, list);
        System.out.println("BBCoreMod: successfully patched getPrevPrevPos" + axis + "!");
    }
}

