/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.core.transformers;

import java.util.ListIterator;
import mchorse.blockbuster.utils.mclib.coremod.ClassTransformer;
import mchorse.blockbuster.utils.mclib.coremod.CoreClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class RenderGlobalTransformer
extends ClassTransformer {
    @Override
    public void process(String name, ClassNode node) {
        for (MethodNode method : node.methods) {
            String methodName = this.checkName(method, "a", "(FI)V", "renderSky", "(FI)V");
            if (methodName != null) {
                this.processRenderSky(method);
            }
            if ((methodName = this.checkName(method, "a", "(FIDDD)V", "renderClouds", "(FIDDD)V")) != null) {
                this.processRenderClouds(method);
            }
            if ((methodName = this.checkName(method, "a", "(Lvg;Lbxy;F)V", "renderEntities", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;F)V")) == null) continue;
            this.processRenderEntities(method);
        }
    }

    private void processRenderSky(MethodNode method) {
        LabelNode label = this.getFirstLabel(method);
        if (label != null) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new MethodInsnNode(184, "mchorse/blockbuster/client/RenderingHandler", "isGreenSky", "()Z", false));
            list.add((AbstractInsnNode)new JumpInsnNode(153, label));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "mchorse/blockbuster/client/RenderingHandler", "renderGreenSky", "()V", false));
            list.add((AbstractInsnNode)new InsnNode(177));
            method.instructions.insert(list);
            System.out.println("BBCoreMod: successfully patched renderSky!");
        }
    }

    private void processRenderClouds(MethodNode method) {
        LabelNode label = this.getFirstLabel(method);
        if (label != null) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new MethodInsnNode(184, "mchorse/blockbuster/client/RenderingHandler", "isGreenSky", "()Z", false));
            list.add((AbstractInsnNode)new JumpInsnNode(153, label));
            list.add((AbstractInsnNode)new InsnNode(177));
            method.instructions.insert(list);
            System.out.println("BBCoreMod: successfully patched renderClouds!");
        }
    }

    private void processRenderEntities(MethodNode method) {
        LabelNode releaseLabel = null;
        LabelNode renderEntityLabel = null;
        LabelNode lastLabel = null;
        ListIterator it = method.instructions.iterator();
        boolean captureNext = false;
        int renderCounter = 0;
        while (it.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            if (node instanceof LabelNode) {
                lastLabel = (LabelNode)node;
                if (!captureNext || renderEntityLabel != null) continue;
                renderEntityLabel = lastLabel;
                captureNext = false;
                continue;
            }
            if (!(node instanceof MethodInsnNode)) continue;
            MethodInsnNode invoke = (MethodInsnNode)node;
            if (CoreClassTransformer.checkName(invoke.owner, "bzf", "net/minecraft/client/renderer/entity/RenderManager") && CoreClassTransformer.checkName(invoke.name, "a", "renderEntityStatic") && CoreClassTransformer.checkName(invoke.desc, "(Lvg;FZ)V", "(Lnet/minecraft/entity/Entity;FZ)V")) {
                if (renderCounter == 1) {
                    captureNext = true;
                }
                ++renderCounter;
            }
            if (!CoreClassTransformer.checkName(invoke.owner, "et$b", "net/minecraft/util/math/BlockPos$PooledMutableBlockPos") || !CoreClassTransformer.checkName(invoke.name, "t", "release") || !invoke.desc.equals("()V")) continue;
            releaseLabel = lastLabel;
            break;
        }
        if (renderEntityLabel != null && releaseLabel != null) {
            String entity = CoreClassTransformer.obfuscated ? "Lvg;" : "Lnet/minecraft/entity/Entity;";
            int localIndex = 0;
            for (LocalVariableNode var : method.localVariables) {
                if (!var.desc.equals(entity)) continue;
                localIndex = Math.max(localIndex, var.index);
            }
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, localIndex));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "mchorse/blockbuster/client/RenderingHandler", "addRenderActor", CoreClassTransformer.obfuscated ? "(" + entity + ")V" : "(" + entity + ")V", false));
            method.instructions.insert((AbstractInsnNode)renderEntityLabel, list);
            method.instructions.insert((AbstractInsnNode)releaseLabel, (AbstractInsnNode)new MethodInsnNode(184, "mchorse/blockbuster/client/RenderingHandler", "renderActors", "()V", false));
            System.out.println("BBCoreMod: successfully patched renderEntities!");
        }
    }
}

