/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.network.common.recording;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.recording.data.Frame;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class PacketFrames
implements IMessage {
    public String filename;
    public int preDelay;
    public int postDelay;
    public List<Frame> frames;

    public PacketFrames() {
    }

    public PacketFrames(String filename, int preDelay, int postDelay, List<Frame> frames) {
        this.filename = filename;
        this.preDelay = preDelay;
        this.postDelay = postDelay;
        this.frames = frames;
    }

    public void fromBytes(ByteBuf buf) {
        ByteBufInputStream input = new ByteBufInputStream(buf);
        ArrayList<Frame> frames = new ArrayList<Frame>();
        try {
            this.filename = input.readUTF();
            this.preDelay = input.readInt();
            this.postDelay = input.readInt();
            int count = input.readInt();
            for (int i = 0; i < count; ++i) {
                Frame frame = new Frame();
                frame.fromBytes((DataInput)input);
                frames.add(frame);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.frames = frames;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufOutputStream output = new ByteBufOutputStream(buf);
        try {
            output.writeUTF(this.filename);
            output.writeInt(this.preDelay);
            output.writeInt(this.postDelay);
            output.writeInt(this.frames.size());
            for (Frame frame : this.frames) {
                frame.toBytes((DataOutput)output);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

