/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.network.server;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.structure.PacketStructure;
import mchorse.blockbuster.network.common.structure.PacketStructureRequest;
import mchorse.mclib.network.ServerMessageHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.DimensionManager;

public class ServerHandlerStructureRequest
extends ServerMessageHandler<PacketStructureRequest> {
    public static List<String> getAllStructures() {
        ArrayList<String> structures = new ArrayList<String>();
        File files = ServerHandlerStructureRequest.getStructureFolder("");
        if (!files.isDirectory()) {
            return structures;
        }
        for (File file : files.listFiles()) {
            String name = file.getName();
            if (!file.isFile() || !name.endsWith(".nbt")) continue;
            structures.add(name.substring(0, name.lastIndexOf(".")));
        }
        return structures;
    }

    public static File getStructureFolder(String name) {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), "structures" + (name.isEmpty() ? "" : "/" + name + ".nbt"));
    }

    public void run(EntityPlayerMP player, PacketStructureRequest message) {
        WorldServer world = player.func_71121_q();
        TemplateManager manager = world.func_184163_y();
        try {
            if (!message.name.isEmpty()) {
                this.sendTemplate(player, message.name, manager.func_186237_a(player.field_71133_b, new ResourceLocation(message.name)));
                return;
            }
            for (String struct : ServerHandlerStructureRequest.getAllStructures()) {
                this.sendTemplate(player, struct, manager.func_186237_a(player.field_71133_b, new ResourceLocation(struct)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendTemplate(EntityPlayerMP player, String key, Template template) {
        NBTTagCompound tag = new NBTTagCompound();
        template.func_189552_a(tag);
        Dispatcher.sendTo(new PacketStructure(key, tag), player);
    }
}

