/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.network.server.recording;

import java.io.IOException;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.capabilities.recording.Recording;
import mchorse.blockbuster.network.common.recording.PacketFramesChunk;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.data.FrameChunk;
import mchorse.blockbuster.recording.data.Record;
import mchorse.mclib.network.ServerMessageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class ServerHandlerFramesChunk
extends ServerMessageHandler<PacketFramesChunk> {
    public void run(EntityPlayerMP player, PacketFramesChunk message) {
        Record serverRecord = CommonProxy.manager.records.get(message.filename);
        FrameChunk chunk = CommonProxy.manager.chunks.get(message.filename);
        if (serverRecord == null) {
            return;
        }
        if (chunk == null) {
            chunk = new FrameChunk(message.count, message.offset);
            CommonProxy.manager.chunks.put(message.filename, chunk);
        }
        chunk.add(message.index, message.frames);
        if (chunk.isFilled()) {
            try {
                Recording.get((EntityPlayer)player).addRecording(message.filename, System.currentTimeMillis());
                serverRecord.frames = chunk.compile(serverRecord.frames);
                serverRecord.save(RecordUtils.replayFile(message.filename));
                serverRecord.fillMissingActions();
                CommonProxy.manager.chunks.remove(message.filename);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

