/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.PacketCaption;
import mchorse.blockbuster.network.common.recording.PacketPlayback;
import mchorse.blockbuster.network.common.recording.PacketPlayerRecording;
import mchorse.blockbuster.recording.MPMHelper;
import mchorse.blockbuster.recording.RecordPlayer;
import mchorse.blockbuster.recording.RecordRecorder;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.ScheduledRecording;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.actions.DamageAction;
import mchorse.blockbuster.recording.data.FrameChunk;
import mchorse.blockbuster.recording.data.Mode;
import mchorse.blockbuster.recording.data.Record;
import mchorse.blockbuster.utils.EntityUtils;
import mchorse.metamorph.api.MorphAPI;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RecordManager {
    public Map<String, Record> records = new HashMap<String, Record>();
    public Map<String, FrameChunk> chunks = new HashMap<String, FrameChunk>();
    public Map<EntityPlayer, RecordRecorder> recorders = new HashMap<EntityPlayer, RecordRecorder>();
    public Map<EntityLivingBase, RecordPlayer> players = new HashMap<EntityLivingBase, RecordPlayer>();
    public Map<EntityPlayer, ScheduledRecording> scheduled = new HashMap<EntityPlayer, ScheduledRecording>();

    public List<Action> getActions(EntityPlayer player) {
        RecordRecorder recorder = this.recorders.get(player);
        return recorder == null ? null : recorder.actions;
    }

    public boolean record(String filename, EntityPlayer player, Mode mode, boolean teleportBack, boolean notify, Runnable runnable) {
        return this.record(filename, player, mode, teleportBack, notify, 0, runnable);
    }

    public boolean record(String filename, EntityPlayer player, Mode mode, boolean teleportBack, boolean notify, int offset, Runnable runnable) {
        Runnable proxy = () -> {
            if (offset > 0 && this.records.get(filename) != null && notify) {
                RecordPlayer recordPlayer = this.play(filename, (EntityLivingBase)player, Mode.ACTIONS, false);
                recordPlayer.tick = offset;
                EntityUtils.setRecordPlayer((EntityLivingBase)player, recordPlayer.realPlayer());
            }
            if (runnable != null) {
                runnable.run();
            }
        };
        if (this.recorders.containsKey(player)) {
            proxy.run();
        }
        if (filename.isEmpty() || this.halt(player, false, notify)) {
            if (filename.isEmpty()) {
                RecordUtils.broadcastError("recording.empty_filename", new Object[0]);
            }
            return false;
        }
        for (RecordRecorder recorder : this.recorders.values()) {
            if (!recorder.record.filename.equals(filename)) continue;
            RecordUtils.broadcastInfo("recording.recording", filename);
            return false;
        }
        RecordRecorder recorder = new RecordRecorder(new Record(filename), mode, player, teleportBack);
        recorder.offset = offset;
        if (player.field_70170_p.field_72995_K) {
            this.recorders.put(player, recorder);
        } else {
            this.setupPlayerData(recorder, player);
            CommonProxy.damage.addDamageControl(recorder, (EntityLivingBase)player);
            this.scheduled.put(player, new ScheduledRecording(recorder, player, proxy, (int)(Blockbuster.recordingCountdown.get() * 20.0f), offset));
        }
        return true;
    }

    private void setupPlayerData(RecordRecorder recorder, EntityPlayer player) {
        NBTTagCompound tag = new NBTTagCompound();
        player.func_70014_b(tag);
        recorder.record.playerData = tag;
        if (MPMHelper.isLoaded() && (tag = MPMHelper.getMPMData(player)) != null) {
            recorder.record.playerData.func_74782_a("MPMData", (NBTBase)tag);
        }
    }

    public boolean halt(EntityPlayer player, boolean hasDied, boolean notify) {
        return this.halt(player, hasDied, notify, false);
    }

    public boolean halt(EntityPlayer player, boolean hasDied, boolean notify, boolean canceled) {
        ScheduledRecording scheduled = this.scheduled.get(player);
        if (scheduled != null) {
            this.scheduled.remove(player);
            Dispatcher.sendTo(new PacketCaption(), (EntityPlayerMP)player);
            return true;
        }
        RecordRecorder recorder = this.recorders.get(player);
        if (recorder != null) {
            Record record = recorder.record;
            String filename = record.filename;
            if (!canceled && hasDied && !record.actions.isEmpty()) {
                record.addAction(record.actions.size() - 1, new DamageAction(200.0f));
            } else {
                recorder.stop(player);
            }
            RecordPlayer recordPlayer = this.players.get(player);
            if (recordPlayer != null && recordPlayer.realPlayer) {
                this.players.remove(player);
                EntityUtils.setRecordPlayer((EntityLivingBase)player, null);
            }
            if (!canceled) {
                try {
                    Record oldRecord = this.get(filename);
                    recorder.applyOld(oldRecord);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.records.put(filename, record);
            }
            this.recorders.remove(player);
            MorphAPI.demorph((EntityPlayer)player);
            if (notify) {
                CommonProxy.damage.restoreDamageControl(recorder, player.field_70170_p);
                Dispatcher.sendTo(new PacketPlayerRecording(false, "", 0, canceled), (EntityPlayerMP)player);
            }
            return true;
        }
        return false;
    }

    public RecordPlayer play(String filename, EntityLivingBase actor, Mode mode, boolean kill) {
        return this.play(filename, actor, mode, 0, kill);
    }

    public RecordPlayer play(String filename, EntityLivingBase actor, Mode mode, int tick, boolean kill) {
        if (this.players.containsKey(actor)) {
            return null;
        }
        try {
            Record record = this.get(filename);
            if (record.frames.size() == 0) {
                RecordUtils.broadcastError("recording.empty_record", filename);
                return null;
            }
            RecordPlayer playback = new RecordPlayer(record, mode, actor);
            playback.tick = tick;
            playback.kill = kill;
            playback.applyFrame(tick, actor, true);
            EntityUtils.setRecordPlayer(actor, playback);
            this.players.put(actor, playback);
            return playback;
        }
        catch (FileNotFoundException e) {
            RecordUtils.broadcastError("recording.not_found", filename);
        }
        catch (Exception e) {
            RecordUtils.broadcastError("recording.read", filename);
            e.printStackTrace();
        }
        return null;
    }

    public void stop(RecordPlayer actor) {
        if (!this.players.containsKey(actor.actor)) {
            return;
        }
        if (actor.actor.func_110143_aJ() > 0.0f) {
            if (actor.kill) {
                actor.actor.func_184210_p();
                if (actor.realPlayer) {
                    if (actor.actor instanceof EntityPlayerMP) {
                        Dispatcher.sendTo(new PacketPlayback(actor.actor.func_145782_y(), false, actor.realPlayer, ""), (EntityPlayerMP)actor.actor);
                    }
                } else {
                    actor.actor.func_70106_y();
                    if (actor.actor instanceof EntityPlayer) {
                        actor.actor.field_70170_p.func_73046_m().func_184103_al().func_72367_e((EntityPlayerMP)actor.actor);
                    }
                }
            } else {
                Dispatcher.sendToTracked((Entity)actor.actor, new PacketPlayback(actor.actor.func_145782_y(), false, actor.realPlayer, ""));
            }
        }
        this.players.remove(actor.actor);
        EntityUtils.setRecordPlayer(actor.actor, null);
    }

    public boolean cancel(EntityPlayer player) {
        return this.halt(player, false, true, true);
    }

    public void reset() {
        for (Record record : this.records.values()) {
            if (!record.dirty) continue;
            try {
                record.save(RecordUtils.replayFile(record.filename));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.records.clear();
        this.chunks.clear();
        this.recorders.clear();
        this.players.clear();
    }

    public void abort(EntityPlayer player) {
        if (this.recorders.containsKey(player)) {
            RecordRecorder recorder = this.recorders.remove(player);
            RecordUtils.broadcastError("recording.logout", recorder.record.filename);
        }
    }

    public Record get(String filename) throws Exception {
        Record record = this.records.get(filename);
        if (record == null) {
            File file = RecordUtils.replayFile(filename);
            record = new Record(filename);
            record.load(file);
            this.records.put(filename, record);
        }
        return record;
    }

    @SideOnly(value=Side.CLIENT)
    public Record getClient(String filename) {
        Record record = this.records.get(filename);
        if (record == null) {
            try {
                InputStream stream = RecordUtils.getLocalReplay(filename);
                NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)stream);
                record = new Record(filename);
                record.load(tag);
                this.records.put(filename, record);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return record;
    }

    public void tick() {
        if (Blockbuster.recordUnload.get() && !this.records.isEmpty()) {
            this.checkAndUnloadRecords();
        }
        if (!this.scheduled.isEmpty()) {
            this.checkScheduled();
        }
    }

    private void checkAndUnloadRecords() {
        Iterator<Map.Entry<String, Record>> iterator = this.records.entrySet().iterator();
        while (iterator.hasNext()) {
            Record record = iterator.next().getValue();
            --record.unload;
            if (record.unload > 0) continue;
            iterator.remove();
            RecordUtils.unloadRecord(record);
            try {
                if (!record.dirty) continue;
                record.save(RecordUtils.replayFile(record.filename));
                record.dirty = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void checkScheduled() {
        Iterator<ScheduledRecording> it = this.scheduled.values().iterator();
        while (it.hasNext()) {
            ScheduledRecording record = it.next();
            if (record.countdown % 2 == 0) {
                PacketCaption message = new PacketCaption((ITextComponent)new TextComponentTranslation("blockbuster.start_recording", new Object[]{record.recorder.record.filename, Float.valueOf((float)record.countdown / 20.0f)}));
                Dispatcher.sendTo(message, (EntityPlayerMP)record.player);
            }
            if (record.countdown <= 0) {
                record.run();
                this.recorders.put(record.player, record.recorder);
                Dispatcher.sendTo(new PacketPlayerRecording(true, record.recorder.record.filename, record.offset, false), (EntityPlayerMP)record.player);
                it.remove();
                continue;
            }
            --record.countdown;
        }
    }

    public void rename(String old, Record record) {
        RecordUtils.unloadRecord(record);
        this.records.remove(old);
        this.records.put(record.filename, record);
        for (String iter : RecordUtils.getReplayIterations(old)) {
            File oldIter = new File(RecordUtils.replayFile(old).getAbsolutePath() + "~" + iter);
            oldIter.renameTo(new File(RecordUtils.replayFile(record.filename).getAbsolutePath() + "~" + iter));
        }
        RecordUtils.replayFile(old).delete();
    }
}

