/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.capabilities.recording.IRecording;
import mchorse.blockbuster.capabilities.recording.Recording;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.recording.PacketFramesLoad;
import mchorse.blockbuster.network.common.recording.PacketRequestedFrames;
import mchorse.blockbuster.network.common.recording.PacketUnloadFrames;
import mchorse.blockbuster.recording.RecordManager;
import mchorse.blockbuster.recording.Utils;
import mchorse.blockbuster.recording.data.Record;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class RecordUtils {
    public static void broadcastMessage(String message) {
        RecordUtils.broadcastMessage((ITextComponent)new TextComponentString(message));
    }

    public static void broadcastMessage(String string, Object ... args) {
        RecordUtils.broadcastMessage((ITextComponent)new TextComponentTranslation(string, args));
    }

    public static void broadcastMessage(ITextComponent message) {
        for (EntityPlayerMP player : RecordUtils.getPlayers()) {
            player.func_145747_a(message);
        }
    }

    public static void broadcastError(String string, Object ... objects) {
        for (EntityPlayerMP player : RecordUtils.getPlayers()) {
            Blockbuster.l10n.error((ICommandSender)player, string, objects);
        }
    }

    public static void broadcastInfo(String string, Object ... objects) {
        for (EntityPlayerMP player : RecordUtils.getPlayers()) {
            Blockbuster.l10n.info((ICommandSender)player, string, objects);
        }
    }

    public static List<EntityPlayerMP> getPlayers() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
    }

    public static boolean isReplayExists(String filename) {
        return RecordUtils.replayFile(filename).exists() || CommonProxy.manager.records.containsKey(filename);
    }

    public static File replayFile(String filename) {
        return Utils.serverFile("blockbuster/records", filename);
    }

    public static InputStream getLocalReplay(String filename) {
        return RecordUtils.class.getResourceAsStream("/assets/blockbuster/records/" + filename + ".dat");
    }

    public static List<String> getReplays() {
        return Utils.serverFiles("blockbuster/records");
    }

    public static List<String> getReplayIterations(String replay) {
        ArrayList<String> list = new ArrayList<String>();
        File replays = new File(DimensionManager.getCurrentSaveRootDirectory() + "/blockbuster/records");
        File[] files = replays.listFiles();
        if (files == null) {
            return list;
        }
        for (File file : files) {
            String name = file.getName();
            if (!file.isFile() || !name.startsWith(replay) || !name.contains(".dat~")) continue;
            list.add(name.substring(name.indexOf("~") + 1));
        }
        return list;
    }

    public static void sendRecord(String filename, EntityPlayerMP player) {
        if (!RecordUtils.playerNeedsAction(filename, (EntityPlayer)player)) {
            return;
        }
        RecordManager manager = CommonProxy.manager;
        Record record = manager.records.get(filename);
        if (record == null) {
            try {
                record = new Record(filename);
                record.load(RecordUtils.replayFile(filename));
                manager.records.put(filename, record);
            }
            catch (FileNotFoundException e) {
                Blockbuster.l10n.error((ICommandSender)player, "recording.not_found", new Object[]{filename});
                record = null;
            }
            catch (Exception e) {
                Blockbuster.l10n.error((ICommandSender)player, "recording.read", new Object[]{filename});
                e.printStackTrace();
                record = null;
            }
        }
        if (record != null) {
            record.resetUnload();
            Dispatcher.sendTo(new PacketFramesLoad(filename, record.preDelay, record.postDelay, record.frames), player);
            System.out.println("Sent " + filename + " to " + player.func_70005_c_());
        }
    }

    public static void sendRequestedRecord(int id, String filename, EntityPlayerMP player) {
        Record record = CommonProxy.manager.records.get(filename);
        if (RecordUtils.playerNeedsAction(filename, (EntityPlayer)player) && record != null) {
            record.resetUnload();
            Dispatcher.sendTo(new PacketRequestedFrames(id, record.filename, record.preDelay, record.postDelay, record.frames), player);
            System.out.println("Sent " + filename + " to " + player.func_70005_c_() + " with " + id);
        } else if (record == null) {
            Blockbuster.l10n.error((ICommandSender)player, "recording.not_found", new Object[]{filename});
        }
    }

    private static boolean playerNeedsAction(String filename, EntityPlayer player) {
        if (RecordUtils.getLocalReplay(filename) != null) {
            return false;
        }
        IRecording recording = Recording.get(player);
        if (recording.isFakePlayer()) {
            return false;
        }
        boolean has = recording.hasRecording(filename);
        long time = RecordUtils.replayFile(filename).lastModified();
        if (has && time > recording.recordingTimestamp(filename)) {
            recording.updateRecordingTimestamp(filename, time);
            return true;
        }
        if (!has) {
            recording.addRecording(filename, time);
        }
        return !has;
    }

    public static void unloadRecord(Record record) {
        String filename = record.filename;
        for (EntityPlayerMP player : RecordUtils.getPlayers()) {
            IRecording recording = Recording.get((EntityPlayer)player);
            if (!recording.hasRecording(filename)) continue;
            recording.removeRecording(filename);
            Dispatcher.sendTo(new PacketUnloadFrames(filename), player);
        }
    }

    public static void saveRecord(Record record) throws IOException {
        RecordUtils.saveRecord(record, true);
    }

    public static void saveRecord(Record record, boolean unload) throws IOException {
        RecordUtils.saveRecord(record, true, unload);
    }

    public static void saveRecord(Record record, boolean savePast, boolean unload) throws IOException {
        record.dirty = false;
        record.save(RecordUtils.replayFile(record.filename), savePast);
        if (unload) {
            RecordUtils.unloadRecord(record);
        }
    }

    public static void dirtyRecord(Record record) {
        record.dirty = true;
        RecordUtils.unloadRecord(record);
    }
}

