/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.actions;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.actions.AttackAction;
import mchorse.blockbuster.recording.actions.BreakBlockAction;
import mchorse.blockbuster.recording.actions.BreakBlockAnimation;
import mchorse.blockbuster.recording.actions.ChatAction;
import mchorse.blockbuster.recording.actions.CommandAction;
import mchorse.blockbuster.recording.actions.DamageAction;
import mchorse.blockbuster.recording.actions.DropAction;
import mchorse.blockbuster.recording.actions.EquipAction;
import mchorse.blockbuster.recording.actions.InteractBlockAction;
import mchorse.blockbuster.recording.actions.InteractEntityAction;
import mchorse.blockbuster.recording.actions.ItemUseAction;
import mchorse.blockbuster.recording.actions.ItemUseBlockAction;
import mchorse.blockbuster.recording.actions.MorphAction;
import mchorse.blockbuster.recording.actions.MorphActionAction;
import mchorse.blockbuster.recording.actions.MountingAction;
import mchorse.blockbuster.recording.actions.PlaceBlockAction;
import mchorse.blockbuster.recording.actions.ShootArrowAction;
import mchorse.blockbuster.recording.actions.SwipeAction;

public class ActionRegistry {
    public static final BiMap<Class<? extends Action>, Byte> CLASS_TO_ID = HashBiMap.create();
    public static final BiMap<String, Class<? extends Action>> NAME_TO_CLASS = HashBiMap.create();
    public static final Map<String, Byte> NAME_TO_ID = new HashMap<String, Byte>();
    private static byte NEXT_ID = 0;

    public static Action fromType(byte type) throws Exception {
        Class clazz = (Class)CLASS_TO_ID.inverse().get((Object)type);
        if (clazz == null) {
            throw new Exception("Action by type '" + type + "' wasn't found!");
        }
        return (Action)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static Action fromName(String name) throws Exception {
        Class clazz = (Class)NAME_TO_CLASS.get((Object)name);
        if (clazz == null) {
            throw new Exception("Action by type '" + name + "' wasn't found!");
        }
        return (Action)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static byte getType(Action action) {
        if (action == null) {
            return -1;
        }
        Byte type = (Byte)CLASS_TO_ID.get(action.getClass());
        return type == null ? (byte)-1 : (byte)type;
    }

    public static void toByteBuf(Action action, ByteBuf buffer) {
        byte type = ActionRegistry.getType(action);
        buffer.writeByte((int)type);
        if (action != null) {
            action.toBuf(buffer);
        }
    }

    public static Action fromByteBuf(ByteBuf buffer) {
        byte type = buffer.readByte();
        if (type == -1) {
            return null;
        }
        try {
            Action action = ActionRegistry.fromType(type);
            action.fromBuf(buffer);
            return action;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void register(String name, Class<? extends Action> clazz) {
        ActionRegistry.register(name, NEXT_ID, clazz);
        NEXT_ID = (byte)(NEXT_ID + 1);
    }

    private static void register(String name, int id, Class<? extends Action> clazz) {
        if (CLASS_TO_ID.containsKey(clazz)) {
            return;
        }
        CLASS_TO_ID.put(clazz, (Object)((byte)id));
        NAME_TO_ID.put(name, (byte)id);
        NAME_TO_CLASS.put((Object)name, clazz);
    }

    static {
        ActionRegistry.register("chat", 1, ChatAction.class);
        ActionRegistry.register("swipe", 2, SwipeAction.class);
        ActionRegistry.register("drop", 3, DropAction.class);
        ActionRegistry.register("equip", 4, EquipAction.class);
        ActionRegistry.register("shoot_arrow", 5, ShootArrowAction.class);
        ActionRegistry.register("place_block", 7, PlaceBlockAction.class);
        ActionRegistry.register("mounting", 8, MountingAction.class);
        ActionRegistry.register("interact_block", 9, InteractBlockAction.class);
        ActionRegistry.register("break_block", 10, BreakBlockAction.class);
        ActionRegistry.register("morph", 12, MorphAction.class);
        ActionRegistry.register("attack", 13, AttackAction.class);
        ActionRegistry.register("damage", 14, DamageAction.class);
        ActionRegistry.register("morph_action", 15, MorphActionAction.class);
        ActionRegistry.register("command", 16, CommandAction.class);
        ActionRegistry.register("break_animation", 17, BreakBlockAnimation.class);
        ActionRegistry.register("use_item", 18, ItemUseAction.class);
        ActionRegistry.register("use_item_block", 19, ItemUseBlockAction.class);
        NEXT_ID = (byte)20;
        ActionRegistry.register("interact_entity", InteractEntityAction.class);
    }
}

