/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.actions;

import io.netty.buffer.ByteBuf;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.mclib.utils.NBTUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class EquipAction
extends Action {
    public byte armorSlot;
    public NBTTagCompound itemData = new NBTTagCompound();

    public EquipAction() {
    }

    public EquipAction(byte armorSlot, ItemStack item) {
        this();
        this.armorSlot = armorSlot;
        if (item != null) {
            item.func_77955_b(this.itemData);
        }
    }

    @Override
    public void apply(EntityLivingBase actor) {
        EntityEquipmentSlot slot = this.getSlotByIndex(this.armorSlot);
        if (slot == null) {
            return;
        }
        if (this.itemData == null) {
            actor.func_184201_a(slot, ItemStack.field_190927_a);
        } else {
            actor.func_184201_a(slot, new ItemStack(this.itemData));
        }
    }

    private EntityEquipmentSlot getSlotByIndex(int index) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188452_c() != index) continue;
            return slot;
        }
        return null;
    }

    @Override
    public void fromBuf(ByteBuf buf) {
        super.fromBuf(buf);
        this.armorSlot = buf.readByte();
        this.itemData = NBTUtils.readInfiniteTag((ByteBuf)buf);
    }

    @Override
    public void toBuf(ByteBuf buf) {
        super.toBuf(buf);
        buf.writeByte((int)this.armorSlot);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.itemData);
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        this.armorSlot = tag.func_74771_c("Slot");
        if (tag.func_74764_b("Data")) {
            this.itemData = tag.func_74775_l("Data");
        }
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        tag.func_74774_a("Slot", this.armorSlot);
        if (this.itemData != null) {
            tag.func_74782_a("Data", (NBTBase)this.itemData);
        }
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

