/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.actions;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import mchorse.blockbuster.common.block.BlockDirector;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.recording.LTHelper;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.utils.EntityUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class InteractBlockAction
extends Action {
    public static final Set<ResourceLocation> BLACKLIST = ImmutableSet.of((Object)new ResourceLocation("littletiles:blocklittletiles"));
    public BlockPos pos = BlockPos.field_177992_a;

    public InteractBlockAction() {
    }

    public InteractBlockAction(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void apply(EntityLivingBase actor) {
        EntityPlayer player;
        IBlockState state = actor.field_70170_p.func_180495_p(this.pos);
        if (state.func_177230_c() instanceof BlockDirector) {
            return;
        }
        Frame frame = EntityUtils.getRecordPlayer(actor).getCurrentFrame();
        EntityPlayer entityPlayer = player = actor instanceof EntityActor ? ((EntityActor)actor).fakePlayer : (EntityPlayer)actor;
        if (frame == null) {
            return;
        }
        if (player != actor) {
            this.copyActor(actor, player, frame);
        }
        if (!LTHelper.playerRightClickServer(player, frame)) {
            if (BLACKLIST.contains(state.func_177230_c().getRegistryName())) {
                return;
            }
            state.func_177230_c().func_180639_a(actor.field_70170_p, this.pos, state, player, EnumHand.MAIN_HAND, null, (float)this.pos.func_177958_n(), (float)this.pos.func_177956_o(), (float)this.pos.func_177952_p());
        }
    }

    @Override
    public void changeOrigin(double rotation, double newX, double newY, double newZ, double firstX, double firstY, double firstZ) {
        firstX = (double)this.pos.func_177958_n() - firstX;
        firstY = (double)this.pos.func_177956_o() - firstY;
        firstZ = (double)this.pos.func_177952_p() - firstZ;
        if (rotation != 0.0) {
            float cos = (float)Math.cos(rotation / 180.0 * Math.PI);
            float sin = (float)Math.sin(rotation / 180.0 * Math.PI);
            double xx = firstX * (double)cos - firstZ * (double)sin;
            double zz = firstX * (double)sin + firstZ * (double)cos;
            firstX = xx;
            firstZ = zz;
        }
        this.pos = new BlockPos(newX += firstX, newY += firstY, newZ += firstZ);
    }

    @Override
    public void flip(String axis, double coordinate) {
        if (axis.equals("x")) {
            double diff = coordinate - (double)this.pos.func_177958_n();
            this.pos = new BlockPos(coordinate + diff, (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p());
        } else {
            double diff = coordinate - (double)this.pos.func_177952_p();
            this.pos = new BlockPos((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), coordinate + diff);
        }
    }

    @Override
    public void fromBuf(ByteBuf buf) {
        super.fromBuf(buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    public void toBuf(ByteBuf buf) {
        super.toBuf(buf);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        this.pos = new BlockPos(tag.func_74762_e("X"), tag.func_74762_e("Y"), tag.func_74762_e("Z"));
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        tag.func_74768_a("X", this.pos.func_177958_n());
        tag.func_74768_a("Y", this.pos.func_177956_o());
        tag.func_74768_a("Z", this.pos.func_177952_p());
    }
}

