/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.actions;

import io.netty.buffer.ByteBuf;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.recording.actions.ItemUseAction;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.utils.EntityUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class ItemUseBlockAction
extends ItemUseAction {
    public BlockPos pos = BlockPos.field_177992_a;
    public EnumFacing facing = EnumFacing.UP;
    public float hitX;
    public float hitY;
    public float hitZ;

    public ItemUseBlockAction() {
    }

    public ItemUseBlockAction(BlockPos pos, EnumHand hand, EnumFacing facing) {
        super(hand);
        this.pos = pos;
        this.facing = facing;
    }

    public ItemUseBlockAction(BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this(pos, hand, facing);
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
    }

    @Override
    public void apply(EntityLivingBase actor) {
        ItemStack item = actor.func_184586_b(this.hand);
        if (item != null) {
            EntityPlayer player;
            Frame frame = EntityUtils.getRecordPlayer(actor).getCurrentFrame();
            EntityPlayer entityPlayer = player = actor instanceof EntityActor ? ((EntityActor)actor).fakePlayer : (EntityPlayer)actor;
            if (frame == null) {
                return;
            }
            player.field_70130_N = actor.field_70130_N;
            player.field_70131_O = actor.field_70131_O;
            player.eyeHeight = actor.func_70047_e();
            player.func_174826_a(actor.func_174813_aQ());
            player.field_70165_t = actor.field_70165_t;
            player.field_70163_u = actor.field_70163_u;
            player.field_70161_v = actor.field_70161_v;
            player.field_70177_z = frame.yaw;
            player.field_70125_A = frame.pitch;
            player.func_184201_a(EntityEquipmentSlot.MAINHAND, actor.func_184614_ca());
            player.func_184201_a(EntityEquipmentSlot.OFFHAND, actor.func_184592_cb());
            ItemStack stack = actor.func_184586_b(this.hand);
            int meta = stack.func_77960_j();
            int size = stack.func_190916_E();
            item.func_77973_b().func_180614_a(player, actor.field_70170_p, this.pos, this.hand, this.facing, this.hitX, this.hitY, this.hitZ);
            stack.func_77964_b(meta);
            stack.func_190920_e(size);
        }
    }

    @Override
    public void changeOrigin(double rotation, double newX, double newY, double newZ, double firstX, double firstY, double firstZ) {
        firstX = (double)this.pos.func_177958_n() - firstX;
        firstX = (double)this.pos.func_177956_o() - firstY;
        firstX = (double)this.pos.func_177952_p() - firstZ;
        if (rotation != 0.0) {
            Vec3d vec = new Vec3d((double)this.hitX, (double)this.hitY, (double)this.hitZ);
            vec = vec.func_178785_b((float)(rotation / 180.0 * Math.PI));
            this.hitX = (float)vec.field_72450_a;
            this.hitY = (float)vec.field_72448_b;
            this.hitZ = (float)vec.field_72449_c;
            float cos = (float)Math.cos(rotation / 180.0 * Math.PI);
            float sin = (float)Math.sin(rotation / 180.0 * Math.PI);
            double xx = firstX * (double)cos - firstZ * (double)sin;
            double zz = firstX * (double)sin + firstZ * (double)cos;
            firstX = xx;
            firstZ = zz;
        }
        this.pos = new BlockPos(newX += firstX, newY += firstY, newZ += firstZ);
    }

    @Override
    public void flip(String axis, double coordinate) {
        if (axis.equals("x")) {
            double diff = coordinate - (double)this.pos.func_177958_n();
            this.hitX = 1.0f - this.hitX;
            this.pos = new BlockPos(coordinate + diff, (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p());
        } else {
            double diff = coordinate - (double)this.pos.func_177952_p();
            this.hitZ = 1.0f - this.hitZ;
            this.pos = new BlockPos((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), coordinate + diff);
        }
    }

    @Override
    public void fromBuf(ByteBuf buf) {
        super.fromBuf(buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.facing = EnumFacing.values()[buf.readByte()];
        this.hitX = buf.readFloat();
        this.hitY = buf.readFloat();
        this.hitZ = buf.readFloat();
    }

    @Override
    public void toBuf(ByteBuf buf) {
        super.toBuf(buf);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeByte((int)((byte)this.facing.ordinal()));
        buf.writeFloat(this.hitX);
        buf.writeFloat(this.hitY);
        buf.writeFloat(this.hitZ);
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        this.pos = new BlockPos(tag.func_74762_e("PosX"), tag.func_74762_e("PosY"), tag.func_74762_e("PosZ"));
        this.facing = EnumFacing.values()[tag.func_74771_c("Facing")];
        this.hitX = tag.func_74760_g("HitX");
        this.hitY = tag.func_74760_g("HitY");
        this.hitZ = tag.func_74760_g("HitZ");
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        tag.func_74768_a("PosX", this.pos.func_177958_n());
        tag.func_74768_a("PosY", this.pos.func_177956_o());
        tag.func_74768_a("PosZ", this.pos.func_177952_p());
        tag.func_74774_a("Facing", (byte)this.facing.ordinal());
        tag.func_74776_a("HitX", this.hitX);
        tag.func_74776_a("HitY", this.hitX);
        tag.func_74776_a("HitZ", this.hitX);
    }
}

