/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.scene;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.mclib.utils.TextUtils;
import mchorse.metamorph.api.MorphAPI;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.vanilla_pack.morphs.PlayerMorph;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class Replay {
    public String id = "";
    public String name = "";
    public String target = "";
    public boolean invincible = false;
    public boolean teleportBack = true;
    public AbstractMorph morph;
    public boolean invisible = false;
    public boolean enabled = true;
    public boolean fake = false;
    public float health = 20.0f;
    public boolean renderLast = false;

    public Replay() {
    }

    public Replay(String id) {
        this.id = id;
    }

    public void apply(EntityLivingBase entity) {
        if (entity instanceof EntityActor) {
            this.apply((EntityActor)entity);
        } else if (entity instanceof EntityPlayer && !(this.morph instanceof PlayerMorph)) {
            this.apply((EntityPlayer)entity);
        }
    }

    public void apply(EntityActor actor) {
        String name = TextUtils.processColoredText((String)this.name);
        actor.func_96094_a(name);
        actor.func_184224_h(this.invincible);
        actor.morph(MorphUtils.copy((AbstractMorph)this.morph), false);
        actor.invisible = this.invisible;
        if (this.health > 20.0f) {
            actor.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.health);
        }
        actor.func_70606_j(this.health);
        actor.renderLast = this.renderLast;
        actor.notifyPlayers();
    }

    public void apply(EntityPlayer player) {
        MorphAPI.morph((EntityPlayer)player, (AbstractMorph)MorphUtils.copy((AbstractMorph)this.morph), (boolean)true);
        player.func_70606_j(this.health);
    }

    public void toNBT(NBTTagCompound tag) {
        tag.func_74778_a("Id", this.id);
        tag.func_74778_a("Name", this.name);
        tag.func_74778_a("Target", this.target);
        if (this.morph != null) {
            tag.func_74782_a("Morph", (NBTBase)this.morph.toNBT());
        }
        tag.func_74757_a("Invincible", this.invincible);
        tag.func_74757_a("Invisible", this.invisible);
        tag.func_74757_a("Enabled", this.enabled);
        tag.func_74757_a("Fake", this.fake);
        if (!this.teleportBack) {
            tag.func_74757_a("TP", this.teleportBack);
        }
        if (this.health != 20.0f) {
            tag.func_74776_a("Health", this.health);
        }
        if (this.renderLast) {
            tag.func_74757_a("RenderLast", this.renderLast);
        }
    }

    public void fromNBT(NBTTagCompound tag) {
        this.id = tag.func_74779_i("Id");
        this.name = tag.func_74779_i("Name");
        this.target = tag.func_74779_i("Target");
        this.morph = MorphManager.INSTANCE.morphFromNBT(tag.func_74775_l("Morph"));
        this.invincible = tag.func_74767_n("Invincible");
        this.invisible = tag.func_74767_n("Invisible");
        this.fake = tag.func_74767_n("Fake");
        if (tag.func_74764_b("Enabled")) {
            this.enabled = tag.func_74767_n("Enabled");
        }
        if (tag.func_74764_b("TP")) {
            this.teleportBack = tag.func_74767_n("TP");
        }
        if (tag.func_74764_b("Health")) {
            this.health = tag.func_74760_g("Health");
        }
        if (tag.func_74764_b("RenderLast")) {
            this.renderLast = tag.func_74767_n("RenderLast");
        }
    }

    public void toBuf(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.id);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.target);
        MorphUtils.morphToBuf((ByteBuf)buf, (AbstractMorph)this.morph);
        buf.writeBoolean(this.invincible);
        buf.writeBoolean(this.invisible);
        buf.writeBoolean(this.enabled);
        buf.writeBoolean(this.fake);
        buf.writeBoolean(this.teleportBack);
        buf.writeBoolean(this.renderLast);
        buf.writeFloat(this.health);
    }

    public void fromBuf(ByteBuf buf) {
        this.id = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.target = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.morph = MorphUtils.morphFromBuf((ByteBuf)buf);
        this.invincible = buf.readBoolean();
        this.invisible = buf.readBoolean();
        this.enabled = buf.readBoolean();
        this.fake = buf.readBoolean();
        this.teleportBack = buf.readBoolean();
        this.renderLast = buf.readBoolean();
        this.health = buf.readFloat();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Replay) {
            Replay replay = (Replay)obj;
            return Objects.equal((Object)replay.id, (Object)this.id) && Objects.equal((Object)replay.name, (Object)this.name) && Objects.equal((Object)replay.target, (Object)this.target) && replay.invincible == this.invincible && replay.invisible == this.invisible && replay.renderLast == this.renderLast && Objects.equal((Object)replay.morph, (Object)this.morph);
        }
        return super.equals(obj);
    }

    public Replay copy() {
        Replay replay = new Replay();
        replay.id = this.id;
        replay.name = this.name;
        replay.target = this.target;
        replay.morph = MorphUtils.copy((AbstractMorph)this.morph);
        replay.invincible = this.invincible;
        replay.invisible = this.invisible;
        replay.enabled = this.enabled;
        replay.fake = this.fake;
        replay.teleportBack = this.teleportBack;
        replay.renderLast = this.renderLast;
        replay.health = this.health;
        return replay;
    }
}

