/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.client.gui;

import java.util.List;
import java.util.function.Consumer;
import mchorse.blockbuster_pack.morphs.SequencerMorph;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.tooltips.LabelTooltip;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.DummyEntity;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.client.gui.creative.GuiMorphRenderer;
import mchorse.metamorph.client.gui.creative.GuiNestedEdit;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSequencerMorph
extends GuiAbstractMorph<SequencerMorph> {
    public GuiSequencerMorphPanel general;

    public GuiSequencerMorph(Minecraft mc) {
        super(mc);
        this.general = new GuiSequencerMorphPanel(mc, this);
        this.defaultPanel = this.general;
        this.registerPanel(this.general, IKey.lang((String)"blockbuster.morph.sequencer"), Icons.GEAR);
    }

    public boolean canEdit(AbstractMorph morph) {
        return morph instanceof SequencerMorph;
    }

    public static class GuiSequenceEntryList
    extends GuiListElement<SequencerMorph.SequenceEntry> {
        public static IKey ticks = IKey.lang((String)"blockbuster.gui.sequencer.ticks");

        public GuiSequenceEntryList(Minecraft mc, Consumer<List<SequencerMorph.SequenceEntry>> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 24;
        }

        protected void drawElementPart(SequencerMorph.SequenceEntry element, int i, int x, int y, boolean hover, boolean selected) {
            GuiContext context = GuiBase.getCurrent();
            if (element.morph != null) {
                GuiDraw.scissor((int)x, (int)y, (int)this.scroll.w, (int)this.scroll.scrollItemSize, (GuiContext)context);
                element.morph.renderOnScreen((EntityPlayer)this.mc.field_71439_g, x + this.scroll.w - 16, y + 30, 20.0f, 1.0f);
                GuiDraw.unscissor((GuiContext)context);
            }
            super.drawElementPart((Object)element, i, x, y, hover, selected);
        }

        protected String elementToString(SequencerMorph.SequenceEntry element) {
            String title = element.duration + " " + ticks.get();
            if (element.morph == null) {
                title = title + " " + I18n.func_135052_a((String)"blockbuster.gui.sequencer.no_morph", (Object[])new Object[0]);
            }
            return title;
        }
    }

    public static class GuiSequencerMorphPanel
    extends GuiMorphPanel<SequencerMorph, GuiSequencerMorph> {
        public GuiElement elements;
        private GuiListElement<SequencerMorph.SequenceEntry> list;
        private GuiButtonElement addPart;
        private GuiButtonElement removePart;
        private GuiNestedEdit pick;
        private GuiTrackpadElement duration;
        private GuiTrackpadElement random;
        private GuiToggleElement setDuration;
        private GuiToggleElement reverse;
        private GuiToggleElement randomOrder;
        private GuiToggleElement trulyRandomOrder;
        public SequencerMorph.SequenceEntry entry;
        public GuiTrackpadElement preview;
        public GuiIconElement plause;
        public GuiIconElement stop;
        private Morph previewMorph = new Morph();
        private DummyEntity dummy;
        private boolean playing;
        private int tick;
        private long lastTick;

        public GuiSequencerMorphPanel(Minecraft mc, GuiSequencerMorph editor) {
            super(mc, (GuiAbstractMorph)editor);
            this.dummy = new DummyEntity((World)Minecraft.func_71410_x().field_71441_e);
            this.elements = new GuiElement(mc);
            this.elements.flex().relative((GuiElement)this).xy(1.0f, 1.0f).w(130).anchor(1.0f, 1.0f).column(5).vertical().stretch().padding(10);
            this.list = new GuiSequenceEntryList(mc, entry -> this.select((SequencerMorph.SequenceEntry)entry.get(0)));
            this.list.sorting().background();
            this.addPart = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.add"), b -> {
                SequencerMorph.SequenceEntry current = (SequencerMorph.SequenceEntry)this.list.getCurrentFirst();
                SequencerMorph.SequenceEntry entry = new SequencerMorph.SequenceEntry(current == null ? null : MorphUtils.copy((AbstractMorph)current.morph));
                if (current != null) {
                    entry.duration = current.duration;
                    entry.random = current.random;
                }
                this.list.getList().add(entry);
                this.list.setIndex(this.list.getList().size() - 1);
                this.select(entry);
                this.list.update();
                this.stopPlayback();
            });
            this.removePart = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.remove"), b -> {
                if (!this.list.isDeselected()) {
                    int index = this.list.getIndex();
                    this.list.getList().remove(index);
                    this.list.setIndex(index - 1);
                    this.select((SequencerMorph.SequenceEntry)this.list.getCurrentFirst());
                    this.list.update();
                    this.stopPlayback();
                }
            });
            this.pick = new GuiNestedEdit(mc, editing -> {
                if (this.entry == null) {
                    return;
                }
                SequencerMorph.SequenceEntry entry = this.entry;
                ((GuiSequencerMorph)this.editor).morphs.nestEdit(entry.morph, editing.booleanValue(), morph -> {
                    entry.morph = MorphUtils.copy((AbstractMorph)morph);
                });
            });
            this.duration = new GuiTrackpadElement(mc, value -> {
                if (this.entry != null) {
                    this.entry.duration = value.floatValue();
                    this.stopPlayback();
                }
            });
            this.duration.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.duration"));
            this.duration.limit(0.0, 3.4028234663852886E38);
            this.random = new GuiTrackpadElement(mc, value -> {
                if (this.entry != null) {
                    this.entry.random = value.floatValue();
                    this.stopPlayback();
                }
            });
            this.random.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.random"));
            this.random.limit(0.0, 3.4028234663852886E38);
            this.setDuration = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.sequencer.set_duration"), b -> {
                this.entry.setDuration = b.isToggled();
            });
            this.setDuration.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.set_duration_tooltip"), Direction.TOP);
            this.reverse = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.sequencer.reverse"), false, b -> {
                ((SequencerMorph)this.morph).reverse = b.isToggled();
                this.stopPlayback();
            });
            this.randomOrder = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.sequencer.random_order"), false, b -> {
                ((SequencerMorph)this.morph).isRandom = b.isToggled();
                this.stopPlayback();
            });
            this.trulyRandomOrder = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.sequencer.truly_random_order"), false, b -> {
                ((SequencerMorph)this.morph).isTrulyRandom = b.isToggled();
                this.stopPlayback();
            });
            this.addPart.flex().relative((IResizer)this.area).set(10.0f, 10.0f, 50.0f, 20.0f);
            this.removePart.flex().relative(this.addPart.resizer()).set(55.0f, 0.0f, 50.0f, 20.0f);
            this.list.flex().relative((IResizer)this.area).set(10.0f, 50.0f, 105.0f, 0.0f).hTo((IResizer)this.reverse.area, -5);
            this.randomOrder.flex().relative((GuiElement)this).x(10).y(1.0f, -24).w(105);
            this.trulyRandomOrder.flex().relative((GuiElement)this.randomOrder).y(-1.0f, -5).w(1.0f);
            this.reverse.flex().relative((GuiElement)this.trulyRandomOrder).y(-1.0f, -5).w(1.0f);
            this.preview = new GuiTrackpadElement(mc, value -> this.previewTick(value.intValue()));
            this.preview.limit(0.0).integer().tooltip(IKey.lang((String)"blockbuster.gui.sequencer.preview_tick"));
            this.plause = new GuiIconElement(mc, Icons.PLAY, b -> this.togglePlay());
            this.plause.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.keys.toggle")).flex().wh(16, 20);
            this.stop = new GuiIconElement(mc, Icons.STOP, b -> this.stopPlayback());
            this.stop.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.keys.stop")).flex().wh(16, 20);
            GuiElement previewBar = new GuiElement(mc);
            previewBar.flex().relative((GuiElement)this).x(130).y(10).wTo((IResizer)this.elements.flex()).h(20).row(5).preferred(1);
            previewBar.add(new IGuiElement[]{this.plause, this.preview, this.stop});
            this.elements.add(new IGuiElement[]{this.pick, this.duration, this.random, this.setDuration});
            this.add(new IGuiElement[]{this.addPart, this.removePart, this.randomOrder, this.trulyRandomOrder, this.reverse, this.list, this.elements, previewBar});
            this.keys().register(((LabelTooltip)this.plause.tooltip).label, 57, () -> this.plause.clickItself(GuiBase.getCurrent())).held(new int[]{42}).category(GuiAbstractMorph.KEY_CATEGORY);
            this.keys().register(((LabelTooltip)this.stop.tooltip).label, 57, () -> this.stop.clickItself(GuiBase.getCurrent())).held(new int[]{56}).category(GuiAbstractMorph.KEY_CATEGORY);
        }

        private void select(SequencerMorph.SequenceEntry entry) {
            this.entry = entry;
            if (entry != null) {
                this.pick.setMorph(entry.morph);
                this.duration.setValue((double)entry.duration);
                this.random.setValue((double)entry.random);
                this.setDuration.toggled(entry.setDuration);
                ((GuiMorphRenderer)((GuiSequencerMorph)this.editor).renderer).morph = entry.morph;
                if (entry.morph instanceof IAnimationProvider) {
                    ((IAnimationProvider)entry.morph).getAnimation().reset();
                }
            } else {
                ((GuiMorphRenderer)((GuiSequencerMorph)this.editor).renderer).morph = null;
            }
            this.elements.setVisible(entry != null);
        }

        private void previewTick(int tick) {
            this.tick = tick;
            if (this.playing) {
                this.togglePlay();
            }
            this.updatePreviewMorph();
        }

        private void togglePlay() {
            this.playing = !this.playing;
            this.updatePlauseButton();
        }

        private void updatePlauseButton() {
            this.plause.both(this.playing ? Icons.PAUSE : Icons.PLAY);
        }

        private void stopPlayback() {
            this.tick = 0;
            this.playing = false;
            this.updatePlauseButton();
            this.preview.setValue(0.0);
            if (this.entry != null) {
                ((GuiMorphRenderer)((GuiSequencerMorph)this.editor).renderer).morph = this.entry.morph;
                if (this.entry.morph instanceof IAnimationProvider) {
                    ((IAnimationProvider)this.entry.morph).getAnimation().reset();
                }
            }
        }

        private void updatePreviewMorph() {
            SequencerMorph.FoundMorph morph = ((SequencerMorph)this.morph).getMorphAt(this.tick);
            if (morph != null) {
                AbstractMorph current = morph.getCurrentMorph();
                AbstractMorph previous = morph.getPreviousMorph();
                current = MorphUtils.copy((AbstractMorph)current);
                previous = MorphUtils.copy((AbstractMorph)previous);
                int prevDuration = (int)morph.getPreviousDuration();
                MorphUtils.pause((AbstractMorph)previous, null, (int)prevDuration);
                MorphUtils.pause((AbstractMorph)current, (AbstractMorph)previous, (int)(this.tick - (int)(morph.totalDuration - morph.getCurrentDuration())));
                this.previewMorph.setDirect(current);
                ((GuiMorphRenderer)((GuiSequencerMorph)this.editor).renderer).morph = this.previewMorph.get();
            }
        }

        private void resetPlayback() {
            this.stopPlayback();
            this.updatePreviewMorph();
        }

        public void fillData(SequencerMorph morph) {
            super.fillData((AbstractMorph)morph);
            this.resetPlayback();
            this.list.setList(morph.morphs);
            this.list.setIndex(0);
            this.select((SequencerMorph.SequenceEntry)this.list.getCurrentFirst());
            this.reverse.toggled(morph.reverse);
            this.randomOrder.toggled(morph.isRandom);
            this.trulyRandomOrder.toggled(morph.isTrulyRandom);
        }

        public void draw(GuiContext context) {
            this.updateLogic(context);
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.sequencer.morphs", (Object[])new Object[0]), (float)this.list.area.x, (float)(this.list.area.y - 12), 0xFFFFFF);
            super.draw(context);
        }

        private void updateLogic(GuiContext context) {
            if (this.playing) {
                for (long i = MathUtils.clamp((long)(context.tick - this.lastTick), (long)0L, (long)10L); i > 0L; --i) {
                    this.updatePreviewMorph();
                    AbstractMorph morph = this.previewMorph.get();
                    if (morph != null) {
                        this.dummy.field_70173_aa = (int)context.tick;
                    }
                    ++this.tick;
                    this.preview.setValue((double)this.tick);
                }
            }
            this.lastTick = context.tick;
        }

        public void fromNBT(NBTTagCompound tag) {
            super.fromNBT(tag);
            this.list.setIndex(tag.func_74762_e("Index"));
            SequencerMorph.SequenceEntry entry = (SequencerMorph.SequenceEntry)this.list.getCurrentFirst();
            if (entry != null) {
                this.select(entry);
            }
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound tag = super.toNBT();
            tag.func_74768_a("Index", this.list.getIndex());
            return tag;
        }
    }
}

