/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.client.gui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.client.particles.BedrockScheme;
import mchorse.blockbuster.utils.mclib.BBIcons;
import mchorse.blockbuster_pack.morphs.SnowstormMorph;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Label;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;

public class GuiSnowstormMorph
extends GuiAbstractMorph<SnowstormMorph> {
    public GuiSnowstormMorph(Minecraft mc) {
        super(mc);
        this.defaultPanel = new GuiSnowstormVariablesMorphPanel(mc, this);
        this.registerPanel(this.defaultPanel, IKey.lang((String)"blockbuster.gui.snowstorm.variables"), BBIcons.PARTICLE);
    }

    public boolean canEdit(AbstractMorph morph) {
        return morph instanceof SnowstormMorph;
    }

    public List<Label<NBTTagCompound>> getPresets(SnowstormMorph morph) {
        ArrayList<Label<NBTTagCompound>> labels = new ArrayList<Label<NBTTagCompound>>();
        for (String preset : Blockbuster.proxy.particles.presets.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Scheme", preset);
            this.addPreset(morph, labels, preset, tag);
        }
        return labels;
    }

    public static class GuiSnowstormVariablesMorphPanel
    extends GuiMorphPanel<SnowstormMorph, GuiSnowstormMorph> {
        public GuiStringListElement variables;
        public GuiTextElement expression;
        private String variable;

        public GuiSnowstormVariablesMorphPanel(Minecraft mc, GuiSnowstormMorph editor) {
            super(mc, (GuiAbstractMorph)editor);
            this.variables = new GuiStringListElement(mc, list -> this.pickVariable((String)list.get(0)));
            this.variables.background();
            this.expression = new GuiTextElement(mc, 1000, this::replaceVariable);
            this.variables.flex().relative((GuiElement)this).xy(10, 22).w(110).hTo((IResizer)this.expression.area, -17);
            this.expression.flex().relative((GuiElement)this).x(10).y(1.0f, -30).w(1.0f, -20).h(20);
            this.add(new IGuiElement[]{this.expression, this.variables});
        }

        public void fillData(SnowstormMorph morph) {
            super.fillData((AbstractMorph)morph);
            HashSet<String> keys = new HashSet<String>();
            BedrockScheme scheme = ((SnowstormMorph)this.morph).getEmitter().scheme;
            for (String key : ((SnowstormMorph)this.morph).variables.keySet()) {
                if (scheme == null || scheme.parser.variables.containsKey(key)) continue;
                keys.add(key);
            }
            for (String key : keys) {
                ((SnowstormMorph)this.morph).variables.remove(key);
            }
            this.variables.clear();
            if (scheme != null) {
                this.variables.add(scheme.parser.variables.keySet());
                this.variables.sort();
            }
            String first = this.variables.getList().isEmpty() ? "" : (String)this.variables.getList().get(0);
            this.pickVariable(first);
            this.expression.setEnabled(!first.isEmpty());
            this.variables.setCurrent((Object)first);
        }

        private void pickVariable(String variable) {
            this.variable = variable;
            String expression = ((SnowstormMorph)this.morph).variables.get(variable);
            this.expression.setEnabled(true);
            this.expression.setText(expression == null ? "" : expression);
        }

        private void replaceVariable(String expression) {
            if (this.variable.isEmpty()) {
                return;
            }
            ((SnowstormMorph)this.morph).replaceVariable(this.variable, expression);
        }

        public void draw(GuiContext context) {
            super.draw(context);
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.snowstorm.variables", (Object[])new Object[0]), (float)this.variables.area.x, (float)(this.variables.area.y - 12), 0xFFFFFF);
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.snowstorm.expression", (Object[])new Object[0]), (float)this.expression.area.x, (float)(this.expression.area.y - 12), 0xFFFFFF);
        }
    }
}

